@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificates
 */
public data class ContainerServicePublicDomainNamesArgs(
    public val certificates: Output<List<ContainerServicePublicDomainNamesCertificateArgs>>,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs.builder()
            .certificates(
                certificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerServicePublicDomainNamesArgs].
 */
@PulumiTagMarker
public class ContainerServicePublicDomainNamesArgsBuilder internal constructor() {
    private var certificates: Output<List<ContainerServicePublicDomainNamesCertificateArgs>>? = null

    /**
     * @param value
     */
    @JvmName("hswciwcgunhyiuas")
    public suspend fun certificates(`value`: Output<List<ContainerServicePublicDomainNamesCertificateArgs>>) {
        this.certificates = value
    }

    @JvmName("txsaifklhuihiula")
    public suspend fun certificates(vararg values: Output<ContainerServicePublicDomainNamesCertificateArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mdebtsnicerllfkb")
    public suspend fun certificates(values: List<Output<ContainerServicePublicDomainNamesCertificateArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fwpqlqlkkrholoyg")
    public suspend fun certificates(`value`: List<ContainerServicePublicDomainNamesCertificateArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ytxojhrwmthcsnbv")
    public suspend fun certificates(argument: List<suspend ContainerServicePublicDomainNamesCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerServicePublicDomainNamesCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("viayvubdvnrcoqjm")
    public suspend fun certificates(vararg argument: suspend ContainerServicePublicDomainNamesCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerServicePublicDomainNamesCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nhcabuemqhdyybsu")
    public suspend fun certificates(argument: suspend ContainerServicePublicDomainNamesCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerServicePublicDomainNamesCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values
     */
    @JvmName("durbvrbexpcjdash")
    public suspend fun certificates(vararg values: ContainerServicePublicDomainNamesCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    internal fun build(): ContainerServicePublicDomainNamesArgs =
        ContainerServicePublicDomainNamesArgs(
            certificates = certificates ?: throw PulumiNullFieldException("certificates"),
        )
}
