@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property behavior The cache behavior for the specified path.
 * @property path The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\*), and file types (\*.html, \*jpg, \*js). Directories and file paths are case-sensitive.
 */
public data class DistributionCacheBehaviorArgs(
    public val behavior: Output<String>,
    public val path: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorArgs =
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorArgs.builder()
            .behavior(behavior.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionCacheBehaviorArgs].
 */
@PulumiTagMarker
public class DistributionCacheBehaviorArgsBuilder internal constructor() {
    private var behavior: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The cache behavior for the specified path.
     */
    @JvmName("xpiywidqjqhlvfyp")
    public suspend fun behavior(`value`: Output<String>) {
        this.behavior = value
    }

    /**
     * @param value The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\*), and file types (\*.html, \*jpg, \*js). Directories and file paths are case-sensitive.
     */
    @JvmName("jtuaynxibumbwghg")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The cache behavior for the specified path.
     */
    @JvmName("tfxfypswifyjnyux")
    public suspend fun behavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.behavior = mapped
    }

    /**
     * @param value The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\*), and file types (\*.html, \*jpg, \*js). Directories and file paths are case-sensitive.
     */
    @JvmName("yogvwdjgmiftbvpt")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): DistributionCacheBehaviorArgs = DistributionCacheBehaviorArgs(
        behavior = behavior ?: throw PulumiNullFieldException("behavior"),
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
