@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHttpMethods The HTTP methods that are processed and forwarded to the distribution's origin.
 * @property cachedHttpMethods The HTTP method responses that are cached by your distribution.
 * @property defaultTtl The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
 * @property forwardedCookies An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
 * @property forwardedHeaders An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
 * @property forwardedQueryStrings An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
 * @property maximumTtl The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
 * @property minimumTtl The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
 */
public data class DistributionCacheBehaviorSettingsArgs(
    public val allowedHttpMethods: Output<String>? = null,
    public val cachedHttpMethods: Output<String>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val forwardedCookies: Output<DistributionCacheBehaviorSettingsForwardedCookiesArgs>? =
        null,
    public val forwardedHeaders: Output<DistributionCacheBehaviorSettingsForwardedHeadersArgs>? =
        null,
    public val forwardedQueryStrings: Output<DistributionCacheBehaviorSettingsForwardedQueryStringsArgs>? = null,
    public val maximumTtl: Output<Int>? = null,
    public val minimumTtl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs =
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs.builder()
            .allowedHttpMethods(allowedHttpMethods?.applyValue({ args0 -> args0 }))
            .cachedHttpMethods(cachedHttpMethods?.applyValue({ args0 -> args0 }))
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .forwardedCookies(forwardedCookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forwardedHeaders(forwardedHeaders?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forwardedQueryStrings(
                forwardedQueryStrings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maximumTtl(maximumTtl?.applyValue({ args0 -> args0 }))
            .minimumTtl(minimumTtl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionCacheBehaviorSettingsArgs].
 */
@PulumiTagMarker
public class DistributionCacheBehaviorSettingsArgsBuilder internal constructor() {
    private var allowedHttpMethods: Output<String>? = null

    private var cachedHttpMethods: Output<String>? = null

    private var defaultTtl: Output<Int>? = null

    private var forwardedCookies: Output<DistributionCacheBehaviorSettingsForwardedCookiesArgs>? =
        null

    private var forwardedHeaders: Output<DistributionCacheBehaviorSettingsForwardedHeadersArgs>? =
        null

    private var forwardedQueryStrings:
        Output<DistributionCacheBehaviorSettingsForwardedQueryStringsArgs>? = null

    private var maximumTtl: Output<Int>? = null

    private var minimumTtl: Output<Int>? = null

    /**
     * @param value The HTTP methods that are processed and forwarded to the distribution's origin.
     */
    @JvmName("gtafpewykhatleld")
    public suspend fun allowedHttpMethods(`value`: Output<String>) {
        this.allowedHttpMethods = value
    }

    /**
     * @param value The HTTP method responses that are cached by your distribution.
     */
    @JvmName("qpcwcyuajkkstcgi")
    public suspend fun cachedHttpMethods(`value`: Output<String>) {
        this.cachedHttpMethods = value
    }

    /**
     * @param value The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
     */
    @JvmName("whaxicijtqnwrsjd")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
     */
    @JvmName("xjawpuyeilelegsn")
    public suspend fun forwardedCookies(`value`: Output<DistributionCacheBehaviorSettingsForwardedCookiesArgs>) {
        this.forwardedCookies = value
    }

    /**
     * @param value An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
     */
    @JvmName("vdkfcfjljlylquab")
    public suspend fun forwardedHeaders(`value`: Output<DistributionCacheBehaviorSettingsForwardedHeadersArgs>) {
        this.forwardedHeaders = value
    }

    /**
     * @param value An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
     */
    @JvmName("firjbcwafhrydbaj")
    public suspend fun forwardedQueryStrings(`value`: Output<DistributionCacheBehaviorSettingsForwardedQueryStringsArgs>) {
        this.forwardedQueryStrings = value
    }

    /**
     * @param value The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     */
    @JvmName("lttuydycamejothh")
    public suspend fun maximumTtl(`value`: Output<Int>) {
        this.maximumTtl = value
    }

    /**
     * @param value The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     */
    @JvmName("hhqnmojmlnucxwdp")
    public suspend fun minimumTtl(`value`: Output<Int>) {
        this.minimumTtl = value
    }

    /**
     * @param value The HTTP methods that are processed and forwarded to the distribution's origin.
     */
    @JvmName("bmjqbykyhcojffge")
    public suspend fun allowedHttpMethods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHttpMethods = mapped
    }

    /**
     * @param value The HTTP method responses that are cached by your distribution.
     */
    @JvmName("jrwaqlnsxibvskgl")
    public suspend fun cachedHttpMethods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachedHttpMethods = mapped
    }

    /**
     * @param value The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
     */
    @JvmName("rkjrwpyhsvdscnjr")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
     */
    @JvmName("ommbkhlknuqyeuqd")
    public suspend fun forwardedCookies(`value`: DistributionCacheBehaviorSettingsForwardedCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedCookies = mapped
    }

    /**
     * @param argument An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
     */
    @JvmName("hnqjmlhbbnvtufwk")
    public suspend fun forwardedCookies(argument: suspend DistributionCacheBehaviorSettingsForwardedCookiesArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionCacheBehaviorSettingsForwardedCookiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardedCookies = mapped
    }

    /**
     * @param value An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
     */
    @JvmName("fntspvoqpdsfexlj")
    public suspend fun forwardedHeaders(`value`: DistributionCacheBehaviorSettingsForwardedHeadersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedHeaders = mapped
    }

    /**
     * @param argument An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
     */
    @JvmName("xpxvjmukktlwakbn")
    public suspend fun forwardedHeaders(argument: suspend DistributionCacheBehaviorSettingsForwardedHeadersArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionCacheBehaviorSettingsForwardedHeadersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardedHeaders = mapped
    }

    /**
     * @param value An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
     */
    @JvmName("hkpxfyrtymkmxulq")
    public suspend fun forwardedQueryStrings(`value`: DistributionCacheBehaviorSettingsForwardedQueryStringsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedQueryStrings = mapped
    }

    /**
     * @param argument An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
     */
    @JvmName("tnduortjbcnfskyh")
    public suspend fun forwardedQueryStrings(argument: suspend DistributionCacheBehaviorSettingsForwardedQueryStringsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionCacheBehaviorSettingsForwardedQueryStringsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedQueryStrings = mapped
    }

    /**
     * @param value The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     */
    @JvmName("phhedyoduntnfweg")
    public suspend fun maximumTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumTtl = mapped
    }

    /**
     * @param value The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
     */
    @JvmName("kdrhwgpshdmcfuqt")
    public suspend fun minimumTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTtl = mapped
    }

    internal fun build(): DistributionCacheBehaviorSettingsArgs =
        DistributionCacheBehaviorSettingsArgs(
            allowedHttpMethods = allowedHttpMethods,
            cachedHttpMethods = cachedHttpMethods,
            defaultTtl = defaultTtl,
            forwardedCookies = forwardedCookies,
            forwardedHeaders = forwardedHeaders,
            forwardedQueryStrings = forwardedQueryStrings,
            maximumTtl = maximumTtl,
            minimumTtl = minimumTtl,
        )
}
