@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property option Indicates whether the distribution forwards and caches based on query strings.
 * @property queryStringsAllowedLists The specific query strings that the distribution forwards to the origin.
 */
public data class DistributionCacheBehaviorSettingsForwardedQueryStringsArgs(
    public val option: Output<Boolean>? = null,
    public val queryStringsAllowedLists: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs =
        com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs.builder()
            .option(option?.applyValue({ args0 -> args0 }))
            .queryStringsAllowedLists(
                queryStringsAllowedLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionCacheBehaviorSettingsForwardedQueryStringsArgs].
 */
@PulumiTagMarker
public class DistributionCacheBehaviorSettingsForwardedQueryStringsArgsBuilder internal constructor() {
    private var option: Output<Boolean>? = null

    private var queryStringsAllowedLists: Output<List<String>>? = null

    /**
     * @param value Indicates whether the distribution forwards and caches based on query strings.
     */
    @JvmName("bgbengipkywdoyud")
    public suspend fun option(`value`: Output<Boolean>) {
        this.option = value
    }

    /**
     * @param value The specific query strings that the distribution forwards to the origin.
     */
    @JvmName("vcxmogmeoprrpvow")
    public suspend fun queryStringsAllowedLists(`value`: Output<List<String>>) {
        this.queryStringsAllowedLists = value
    }

    @JvmName("fyvbxlkhhdidnxrw")
    public suspend fun queryStringsAllowedLists(vararg values: Output<String>) {
        this.queryStringsAllowedLists = Output.all(values.asList())
    }

    /**
     * @param values The specific query strings that the distribution forwards to the origin.
     */
    @JvmName("vbqsxbkjkkjhpocl")
    public suspend fun queryStringsAllowedLists(values: List<Output<String>>) {
        this.queryStringsAllowedLists = Output.all(values)
    }

    /**
     * @param value Indicates whether the distribution forwards and caches based on query strings.
     */
    @JvmName("fplytupbkywihlix")
    public suspend fun option(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.option = mapped
    }

    /**
     * @param value The specific query strings that the distribution forwards to the origin.
     */
    @JvmName("vcanxypkmlpjfsws")
    public suspend fun queryStringsAllowedLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringsAllowedLists = mapped
    }

    /**
     * @param values The specific query strings that the distribution forwards to the origin.
     */
    @JvmName("qpdfbpmnpivnmgmt")
    public suspend fun queryStringsAllowedLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringsAllowedLists = mapped
    }

    internal fun build(): DistributionCacheBehaviorSettingsForwardedQueryStringsArgs =
        DistributionCacheBehaviorSettingsForwardedQueryStringsArgs(
            option = option,
            queryStringsAllowedLists = queryStringsAllowedLists,
        )
}
