@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property behavior The cache behavior of the distribution. Valid values: `cache` and `dont-cache`.
 */
public data class DistributionDefaultCacheBehaviorArgs(
    public val behavior: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs =
        com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs.builder()
            .behavior(behavior.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionDefaultCacheBehaviorArgs].
 */
@PulumiTagMarker
public class DistributionDefaultCacheBehaviorArgsBuilder internal constructor() {
    private var behavior: Output<String>? = null

    /**
     * @param value The cache behavior of the distribution. Valid values: `cache` and `dont-cache`.
     */
    @JvmName("xnyvlhinnkdxsgnx")
    public suspend fun behavior(`value`: Output<String>) {
        this.behavior = value
    }

    /**
     * @param value The cache behavior of the distribution. Valid values: `cache` and `dont-cache`.
     */
    @JvmName("jurvrqmscftfuaps")
    public suspend fun behavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.behavior = mapped
    }

    internal fun build(): DistributionDefaultCacheBehaviorArgs = DistributionDefaultCacheBehaviorArgs(
        behavior = behavior ?: throw PulumiNullFieldException("behavior"),
    )
}
