@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cidrListAliases Set of CIDR aliases that define access for a preconfigured range of IP addresses.
 * @property cidrs Set of CIDR blocks.
 * @property fromPort First port in a range of open ports on an instance.
 * @property ipv6Cidrs
 * @property protocol IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
 * @property toPort Last port in a range of open ports on an instance.
 * The following arguments are optional:
 */
public data class InstancePublicPortsPortInfoArgs(
    public val cidrListAliases: Output<List<String>>? = null,
    public val cidrs: Output<List<String>>? = null,
    public val fromPort: Output<Int>,
    public val ipv6Cidrs: Output<List<String>>? = null,
    public val protocol: Output<String>,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs =
        com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs.builder()
            .cidrListAliases(cidrListAliases?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cidrs(cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .ipv6Cidrs(ipv6Cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstancePublicPortsPortInfoArgs].
 */
@PulumiTagMarker
public class InstancePublicPortsPortInfoArgsBuilder internal constructor() {
    private var cidrListAliases: Output<List<String>>? = null

    private var cidrs: Output<List<String>>? = null

    private var fromPort: Output<Int>? = null

    private var ipv6Cidrs: Output<List<String>>? = null

    private var protocol: Output<String>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value Set of CIDR aliases that define access for a preconfigured range of IP addresses.
     */
    @JvmName("ncwrmcpdlpjkwjfo")
    public suspend fun cidrListAliases(`value`: Output<List<String>>) {
        this.cidrListAliases = value
    }

    @JvmName("lvyrfrqbfpmtvqbb")
    public suspend fun cidrListAliases(vararg values: Output<String>) {
        this.cidrListAliases = Output.all(values.asList())
    }

    /**
     * @param values Set of CIDR aliases that define access for a preconfigured range of IP addresses.
     */
    @JvmName("ecfwovofpgvvhyyh")
    public suspend fun cidrListAliases(values: List<Output<String>>) {
        this.cidrListAliases = Output.all(values)
    }

    /**
     * @param value Set of CIDR blocks.
     */
    @JvmName("mvdyqmfmckrussds")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("bpvpagfjcamhlccm")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values Set of CIDR blocks.
     */
    @JvmName("uqflpjudnnpifpwm")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value First port in a range of open ports on an instance.
     */
    @JvmName("omktkdhgcvtlnwqy")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value
     */
    @JvmName("xapnscljmhsicbta")
    public suspend fun ipv6Cidrs(`value`: Output<List<String>>) {
        this.ipv6Cidrs = value
    }

    @JvmName("mdwopsriwhyvdpoi")
    public suspend fun ipv6Cidrs(vararg values: Output<String>) {
        this.ipv6Cidrs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("buwngbvacxyopaxu")
    public suspend fun ipv6Cidrs(values: List<Output<String>>) {
        this.ipv6Cidrs = Output.all(values)
    }

    /**
     * @param value IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
     */
    @JvmName("objbpplctmdhsgjb")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Last port in a range of open ports on an instance.
     * The following arguments are optional:
     */
    @JvmName("krurqfyhwjqotiho")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value Set of CIDR aliases that define access for a preconfigured range of IP addresses.
     */
    @JvmName("hdkujtkmrxinfkmm")
    public suspend fun cidrListAliases(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrListAliases = mapped
    }

    /**
     * @param values Set of CIDR aliases that define access for a preconfigured range of IP addresses.
     */
    @JvmName("xbubktblciqjuwnr")
    public suspend fun cidrListAliases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrListAliases = mapped
    }

    /**
     * @param value Set of CIDR blocks.
     */
    @JvmName("liovvcxdahkxmetf")
    public suspend fun cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values Set of CIDR blocks.
     */
    @JvmName("jvlopygrvjunatpg")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param value First port in a range of open ports on an instance.
     */
    @JvmName("sioylftqbhyqanbl")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("nnmcwepgtiwrmmqe")
    public suspend fun ipv6Cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Cidrs = mapped
    }

    /**
     * @param values
     */
    @JvmName("txtdbvpiechrexec")
    public suspend fun ipv6Cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Cidrs = mapped
    }

    /**
     * @param value IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
     */
    @JvmName("xvlcsgirroyvcnol")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Last port in a range of open ports on an instance.
     * The following arguments are optional:
     */
    @JvmName("ihqbyaitywoaxcqi")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): InstancePublicPortsPortInfoArgs = InstancePublicPortsPortInfoArgs(
        cidrListAliases = cidrListAliases,
        cidrs = cidrs,
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        ipv6Cidrs = ipv6Cidrs,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
