@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property commands The launch command for the container. A list of string.
 * @property containerName The name for the container.
 * @property environment A key-value map of the environment variables of the container.
 * @property image The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
 * @property ports A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
 */
public data class ContainerServiceDeploymentVersionContainer(
    public val commands: List<String>? = null,
    public val containerName: String,
    public val environment: Map<String, String>? = null,
    public val image: String,
    public val ports: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.ContainerServiceDeploymentVersionContainer): ContainerServiceDeploymentVersionContainer = ContainerServiceDeploymentVersionContainer(
            commands = javaType.commands().map({ args0 -> args0 }),
            containerName = javaType.containerName(),
            environment = javaType.environment().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            image = javaType.image(),
            ports = javaType.ports().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
