@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property isActive A Boolean value that indicates whether to activate the role. The default is `false`.
 * @property principalArn The principal ARN of the container service. The principal ARN can be used to create a trust
 * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
 * service permission to access resources in your standard AWS account.
 */
public data class ContainerServicePrivateRegistryAccessEcrImagePullerRole(
    public val isActive: Boolean? = null,
    public val principalArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.ContainerServicePrivateRegistryAccessEcrImagePullerRole): ContainerServicePrivateRegistryAccessEcrImagePullerRole =
            ContainerServicePrivateRegistryAccessEcrImagePullerRole(
                isActive = javaType.isActive().map({ args0 -> args0 }).orElse(null),
                principalArn = javaType.principalArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
