@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property behavior The cache behavior for the specified path.
 * @property path The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\*), and file types (\*.html, \*jpg, \*js). Directories and file paths are case-sensitive.
 */
public data class DistributionCacheBehavior(
    public val behavior: String,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionCacheBehavior): DistributionCacheBehavior = DistributionCacheBehavior(
            behavior = javaType.behavior(),
            path = javaType.path(),
        )
    }
}
