@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cookiesAllowLists The specific cookies to forward to your distribution's origin.
 * @property option Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
 */
public data class DistributionCacheBehaviorSettingsForwardedCookies(
    public val cookiesAllowLists: List<String>? = null,
    public val option: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionCacheBehaviorSettingsForwardedCookies): DistributionCacheBehaviorSettingsForwardedCookies =
            DistributionCacheBehaviorSettingsForwardedCookies(
                cookiesAllowLists = javaType.cookiesAllowLists().map({ args0 -> args0 }),
                option = javaType.option().map({ args0 -> args0 }).orElse(null),
            )
    }
}
