@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headersAllowLists The specific headers to forward to your distribution's origin.
 * @property option The headers that you want your distribution to forward to your origin and base caching on.
 */
public data class DistributionCacheBehaviorSettingsForwardedHeaders(
    public val headersAllowLists: List<String>? = null,
    public val option: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionCacheBehaviorSettingsForwardedHeaders): DistributionCacheBehaviorSettingsForwardedHeaders =
            DistributionCacheBehaviorSettingsForwardedHeaders(
                headersAllowLists = javaType.headersAllowLists().map({ args0 -> args0 }),
                option = javaType.option().map({ args0 -> args0 }).orElse(null),
            )
    }
}
