@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
 * @property protocolPolicy The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
 * @property regionName The AWS Region name of the origin resource.
 * @property resourceType The resource type of the origin resource (e.g., Instance).
 */
public data class DistributionOrigin(
    public val name: String,
    public val protocolPolicy: String? = null,
    public val regionName: String,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.DistributionOrigin): DistributionOrigin = DistributionOrigin(
            name = javaType.name(),
            protocolPolicy = javaType.protocolPolicy().map({ args0 -> args0 }).orElse(null),
            regionName = javaType.regionName(),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
