@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidrListAliases Set of CIDR aliases that define access for a preconfigured range of IP addresses.
 * @property cidrs Set of CIDR blocks.
 * @property fromPort First port in a range of open ports on an instance.
 * @property ipv6Cidrs
 * @property protocol IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
 * @property toPort Last port in a range of open ports on an instance.
 * The following arguments are optional:
 */
public data class InstancePublicPortsPortInfo(
    public val cidrListAliases: List<String>? = null,
    public val cidrs: List<String>? = null,
    public val fromPort: Int,
    public val ipv6Cidrs: List<String>? = null,
    public val protocol: String,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lightsail.outputs.InstancePublicPortsPortInfo): InstancePublicPortsPortInfo = InstancePublicPortsPortInfo(
            cidrListAliases = javaType.cidrListAliases().map({ args0 -> args0 }),
            cidrs = javaType.cidrs().map({ args0 -> args0 }),
            fromPort = javaType.fromPort(),
            ipv6Cidrs = javaType.ipv6Cidrs().map({ args0 -> args0 }),
            protocol = javaType.protocol(),
            toPort = javaType.toPort(),
        )
    }
}
