@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.aws.location.LocationFunctions.getGeofenceCollectionPlain
import com.pulumi.aws.location.LocationFunctions.getMapPlain
import com.pulumi.aws.location.LocationFunctions.getPlaceIndexPlain
import com.pulumi.aws.location.LocationFunctions.getRouteCalculatorPlain
import com.pulumi.aws.location.LocationFunctions.getTrackerAssociationPlain
import com.pulumi.aws.location.LocationFunctions.getTrackerAssociationsPlain
import com.pulumi.aws.location.LocationFunctions.getTrackerPlain
import com.pulumi.aws.location.kotlin.inputs.GetGeofenceCollectionPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetGeofenceCollectionPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetMapPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetMapPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetPlaceIndexPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetPlaceIndexPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetRouteCalculatorPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetRouteCalculatorPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetTrackerAssociationPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetTrackerAssociationPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetTrackerAssociationsPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetTrackerAssociationsPlainArgsBuilder
import com.pulumi.aws.location.kotlin.inputs.GetTrackerPlainArgs
import com.pulumi.aws.location.kotlin.inputs.GetTrackerPlainArgsBuilder
import com.pulumi.aws.location.kotlin.outputs.GetGeofenceCollectionResult
import com.pulumi.aws.location.kotlin.outputs.GetMapResult
import com.pulumi.aws.location.kotlin.outputs.GetPlaceIndexResult
import com.pulumi.aws.location.kotlin.outputs.GetRouteCalculatorResult
import com.pulumi.aws.location.kotlin.outputs.GetTrackerAssociationResult
import com.pulumi.aws.location.kotlin.outputs.GetTrackerAssociationsResult
import com.pulumi.aws.location.kotlin.outputs.GetTrackerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.location.kotlin.outputs.GetGeofenceCollectionResult.Companion.toKotlin as getGeofenceCollectionResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetMapResult.Companion.toKotlin as getMapResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetPlaceIndexResult.Companion.toKotlin as getPlaceIndexResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetRouteCalculatorResult.Companion.toKotlin as getRouteCalculatorResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetTrackerAssociationResult.Companion.toKotlin as getTrackerAssociationResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetTrackerAssociationsResult.Companion.toKotlin as getTrackerAssociationsResultToKotlin
import com.pulumi.aws.location.kotlin.outputs.GetTrackerResult.Companion.toKotlin as getTrackerResultToKotlin

public object LocationFunctions {
    /**
     * Retrieve information about a Location Service Geofence Collection.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getGeofenceCollection({
     *     collectionName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_geofence_collection(collection_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetGeofenceCollection.Invoke(new()
     *     {
     *         CollectionName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.LookupGeofenceCollection(ctx, &location.LookupGeofenceCollectionArgs{
     * 			CollectionName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetGeofenceCollectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getGeofenceCollection(GetGeofenceCollectionArgs.builder()
     *             .collectionName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getGeofenceCollection
     *       Arguments:
     *         collectionName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGeofenceCollection.
     * @return A collection of values returned by getGeofenceCollection.
     */
    public suspend fun getGeofenceCollection(argument: GetGeofenceCollectionPlainArgs): GetGeofenceCollectionResult =
        getGeofenceCollectionResultToKotlin(getGeofenceCollectionPlain(argument.toJava()).await())

    /**
     * @see [getGeofenceCollection].
     * @param collectionName Name of the geofence collection.
     * @param kmsKeyId Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     * @param tags Key-value map of resource tags for the geofence collection.
     * @return A collection of values returned by getGeofenceCollection.
     */
    public suspend fun getGeofenceCollection(
        collectionName: String,
        kmsKeyId: String? = null,
        tags: Map<String, String>? = null,
    ): GetGeofenceCollectionResult {
        val argument = GetGeofenceCollectionPlainArgs(
            collectionName = collectionName,
            kmsKeyId = kmsKeyId,
            tags = tags,
        )
        return getGeofenceCollectionResultToKotlin(getGeofenceCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getGeofenceCollection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetGeofenceCollectionPlainArgs].
     * @return A collection of values returned by getGeofenceCollection.
     */
    public suspend fun getGeofenceCollection(argument: suspend GetGeofenceCollectionPlainArgsBuilder.() -> Unit): GetGeofenceCollectionResult {
        val builder = GetGeofenceCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGeofenceCollectionResultToKotlin(getGeofenceCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Location Service Map.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getMap({
     *     mapName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_map(map_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetMap.Invoke(new()
     *     {
     *         MapName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.LookupMap(ctx, &location.LookupMapArgs{
     * 			MapName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetMapArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getMap(GetMapArgs.builder()
     *             .mapName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getMap
     *       Arguments:
     *         mapName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMap.
     * @return A collection of values returned by getMap.
     */
    public suspend fun getMap(argument: GetMapPlainArgs): GetMapResult =
        getMapResultToKotlin(getMapPlain(argument.toJava()).await())

    /**
     * @see [getMap].
     * @param mapName Name of the map resource.
     * @param tags Key-value map of resource tags for the map.
     * @return A collection of values returned by getMap.
     */
    public suspend fun getMap(mapName: String, tags: Map<String, String>? = null): GetMapResult {
        val argument = GetMapPlainArgs(
            mapName = mapName,
            tags = tags,
        )
        return getMapResultToKotlin(getMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getMap].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetMapPlainArgs].
     * @return A collection of values returned by getMap.
     */
    public suspend fun getMap(argument: suspend GetMapPlainArgsBuilder.() -> Unit): GetMapResult {
        val builder = GetMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMapResultToKotlin(getMapPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Location Service Place Index.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getPlaceIndex({
     *     indexName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_place_index(index_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetPlaceIndex.Invoke(new()
     *     {
     *         IndexName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.LookupPlaceIndex(ctx, &location.LookupPlaceIndexArgs{
     * 			IndexName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetPlaceIndexArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getPlaceIndex(GetPlaceIndexArgs.builder()
     *             .indexName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getPlaceIndex
     *       Arguments:
     *         indexName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPlaceIndex.
     * @return A collection of values returned by getPlaceIndex.
     */
    public suspend fun getPlaceIndex(argument: GetPlaceIndexPlainArgs): GetPlaceIndexResult =
        getPlaceIndexResultToKotlin(getPlaceIndexPlain(argument.toJava()).await())

    /**
     * @see [getPlaceIndex].
     * @param indexName Name of the place index resource.
     * @param tags Key-value map of resource tags for the place index.
     * @return A collection of values returned by getPlaceIndex.
     */
    public suspend fun getPlaceIndex(indexName: String, tags: Map<String, String>? = null): GetPlaceIndexResult {
        val argument = GetPlaceIndexPlainArgs(
            indexName = indexName,
            tags = tags,
        )
        return getPlaceIndexResultToKotlin(getPlaceIndexPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlaceIndex].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetPlaceIndexPlainArgs].
     * @return A collection of values returned by getPlaceIndex.
     */
    public suspend fun getPlaceIndex(argument: suspend GetPlaceIndexPlainArgsBuilder.() -> Unit): GetPlaceIndexResult {
        val builder = GetPlaceIndexPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPlaceIndexResultToKotlin(getPlaceIndexPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Location Service Route Calculator.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getRouteCalculator({
     *     calculatorName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_route_calculator(calculator_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetRouteCalculator.Invoke(new()
     *     {
     *         CalculatorName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.GetRouteCalculator(ctx, &location.GetRouteCalculatorArgs{
     * 			CalculatorName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetRouteCalculatorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getRouteCalculator(GetRouteCalculatorArgs.builder()
     *             .calculatorName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getRouteCalculator
     *       Arguments:
     *         calculatorName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteCalculator.
     * @return A collection of values returned by getRouteCalculator.
     */
    public suspend fun getRouteCalculator(argument: GetRouteCalculatorPlainArgs): GetRouteCalculatorResult =
        getRouteCalculatorResultToKotlin(getRouteCalculatorPlain(argument.toJava()).await())

    /**
     * @see [getRouteCalculator].
     * @param calculatorName Name of the route calculator resource.
     * @param tags Key-value map of resource tags for the route calculator.
     * @return A collection of values returned by getRouteCalculator.
     */
    public suspend fun getRouteCalculator(calculatorName: String, tags: Map<String, String>? = null): GetRouteCalculatorResult {
        val argument = GetRouteCalculatorPlainArgs(
            calculatorName = calculatorName,
            tags = tags,
        )
        return getRouteCalculatorResultToKotlin(getRouteCalculatorPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteCalculator].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetRouteCalculatorPlainArgs].
     * @return A collection of values returned by getRouteCalculator.
     */
    public suspend fun getRouteCalculator(argument: suspend GetRouteCalculatorPlainArgsBuilder.() -> Unit): GetRouteCalculatorResult {
        val builder = GetRouteCalculatorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteCalculatorResultToKotlin(getRouteCalculatorPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Location Service Tracker.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getTracker({
     *     trackerName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_tracker(tracker_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetTracker.Invoke(new()
     *     {
     *         TrackerName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.LookupTracker(ctx, &location.LookupTrackerArgs{
     * 			TrackerName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetTrackerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getTracker(GetTrackerArgs.builder()
     *             .trackerName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getTracker
     *       Arguments:
     *         trackerName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTracker.
     * @return A collection of values returned by getTracker.
     */
    public suspend fun getTracker(argument: GetTrackerPlainArgs): GetTrackerResult =
        getTrackerResultToKotlin(getTrackerPlain(argument.toJava()).await())

    /**
     * @see [getTracker].
     * @param tags Key-value map of resource tags for the tracker.
     * @param trackerName Name of the tracker resource.
     * @return A collection of values returned by getTracker.
     */
    public suspend fun getTracker(tags: Map<String, String>? = null, trackerName: String): GetTrackerResult {
        val argument = GetTrackerPlainArgs(
            tags = tags,
            trackerName = trackerName,
        )
        return getTrackerResultToKotlin(getTrackerPlain(argument.toJava()).await())
    }

    /**
     * @see [getTracker].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetTrackerPlainArgs].
     * @return A collection of values returned by getTracker.
     */
    public suspend fun getTracker(argument: suspend GetTrackerPlainArgsBuilder.() -> Unit): GetTrackerResult {
        val builder = GetTrackerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrackerResultToKotlin(getTrackerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Location Service Tracker Association.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getTrackerAssociation({
     *     consumerArn: "arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer",
     *     trackerName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_tracker_association(consumer_arn="arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer",
     *     tracker_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetTrackerAssociation.Invoke(new()
     *     {
     *         ConsumerArn = "arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer",
     *         TrackerName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.LookupTrackerAssociation(ctx, &location.LookupTrackerAssociationArgs{
     * 			ConsumerArn: "arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer",
     * 			TrackerName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetTrackerAssociationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getTrackerAssociation(GetTrackerAssociationArgs.builder()
     *             .consumerArn("arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer")
     *             .trackerName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getTrackerAssociation
     *       Arguments:
     *         consumerArn: arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer
     *         trackerName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrackerAssociation.
     * @return A collection of values returned by getTrackerAssociation.
     */
    public suspend fun getTrackerAssociation(argument: GetTrackerAssociationPlainArgs): GetTrackerAssociationResult =
        getTrackerAssociationResultToKotlin(getTrackerAssociationPlain(argument.toJava()).await())

    /**
     * @see [getTrackerAssociation].
     * @param consumerArn ARN of the geofence collection associated to tracker resource.
     * @param trackerName Name of the tracker resource associated with a geofence collection.
     * @return A collection of values returned by getTrackerAssociation.
     */
    public suspend fun getTrackerAssociation(consumerArn: String, trackerName: String): GetTrackerAssociationResult {
        val argument = GetTrackerAssociationPlainArgs(
            consumerArn = consumerArn,
            trackerName = trackerName,
        )
        return getTrackerAssociationResultToKotlin(getTrackerAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrackerAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetTrackerAssociationPlainArgs].
     * @return A collection of values returned by getTrackerAssociation.
     */
    public suspend fun getTrackerAssociation(argument: suspend GetTrackerAssociationPlainArgsBuilder.() -> Unit): GetTrackerAssociationResult {
        val builder = GetTrackerAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrackerAssociationResultToKotlin(getTrackerAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about Location Service Tracker Associations.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.location.getTrackerAssociations({
     *     trackerName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.location.get_tracker_associations(tracker_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Location.GetTrackerAssociations.Invoke(new()
     *     {
     *         TrackerName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := location.GetTrackerAssociations(ctx, &location.GetTrackerAssociationsArgs{
     * 			TrackerName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.location.LocationFunctions;
     * import com.pulumi.aws.location.inputs.GetTrackerAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LocationFunctions.getTrackerAssociations(GetTrackerAssociationsArgs.builder()
     *             .trackerName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:location:getTrackerAssociations
     *       Arguments:
     *         trackerName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrackerAssociations.
     * @return A collection of values returned by getTrackerAssociations.
     */
    public suspend fun getTrackerAssociations(argument: GetTrackerAssociationsPlainArgs): GetTrackerAssociationsResult =
        getTrackerAssociationsResultToKotlin(getTrackerAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getTrackerAssociations].
     * @param trackerName Name of the tracker resource associated with a geofence collection.
     * @return A collection of values returned by getTrackerAssociations.
     */
    public suspend fun getTrackerAssociations(trackerName: String): GetTrackerAssociationsResult {
        val argument = GetTrackerAssociationsPlainArgs(
            trackerName = trackerName,
        )
        return getTrackerAssociationsResultToKotlin(getTrackerAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrackerAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;location&#46;kotlin&#46;inputs&#46;GetTrackerAssociationsPlainArgs].
     * @return A collection of values returned by getTrackerAssociations.
     */
    public suspend fun getTrackerAssociations(argument: suspend GetTrackerAssociationsPlainArgsBuilder.() -> Unit): GetTrackerAssociationsResult {
        val builder = GetTrackerAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrackerAssociationsResultToKotlin(getTrackerAssociationsPlain(builtArgument.toJava()).await())
    }
}
