@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Tracker].
 */
@PulumiTagMarker
public class TrackerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrackerArgs = TrackerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrackerArgsBuilder.() -> Unit) {
        val builder = TrackerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Tracker {
        val builtJavaResource = com.pulumi.aws.location.Tracker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tracker(builtJavaResource)
    }
}

/**
 * Provides a Location Service Tracker.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.location.Tracker("example", {trackerName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.location.Tracker("example", tracker_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Location.Tracker("example", new()
 *     {
 *         TrackerName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := location.NewTracker(ctx, "example", &location.TrackerArgs{
 * 			TrackerName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.Tracker;
 * import com.pulumi.aws.location.TrackerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Tracker("example", TrackerArgs.builder()
 *             .trackerName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:location:Tracker
 *     properties:
 *       trackerName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_location_tracker` resources using the tracker name. For example:
 * ```sh
 * $ pulumi import aws:location/tracker:Tracker example example
 * ```
 */
public class Tracker internal constructor(
    override val javaResource: com.pulumi.aws.location.Tracker,
) : KotlinCustomResource(javaResource, TrackerMapper) {
    /**
     * The timestamp for when the tracker resource was created in ISO 8601 format.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The optional description for the tracker resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The position filtering method of the tracker resource. Valid values: `TimeBased`, `DistanceBased`, `AccuracyBased`. Default: `TimeBased`.
     */
    public val positionFiltering: Output<String>?
        get() = javaResource.positionFiltering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value tags for the tracker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.
     */
    public val trackerArn: Output<String>
        get() = javaResource.trackerArn().applyValue({ args0 -> args0 })

    /**
     * The name of the tracker resource.
     * The following arguments are optional:
     */
    public val trackerName: Output<String>
        get() = javaResource.trackerName().applyValue({ args0 -> args0 })

    /**
     * The timestamp for when the tracker resource was last updated in ISO 8601 format.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object TrackerMapper : ResourceMapper<Tracker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.Tracker::class == javaResource::class

    override fun map(javaResource: Resource): Tracker = Tracker(
        javaResource as
            com.pulumi.aws.location.Tracker,
    )
}

/**
 * @see [Tracker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tracker].
 */
public suspend fun tracker(name: String, block: suspend TrackerResourceBuilder.() -> Unit): Tracker {
    val builder = TrackerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tracker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tracker(name: String): Tracker {
    val builder = TrackerResourceBuilder()
    builder.name(name)
    return builder.build()
}
