@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrackerAssociation].
 */
@PulumiTagMarker
public class TrackerAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrackerAssociationArgs = TrackerAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrackerAssociationArgsBuilder.() -> Unit) {
        val builder = TrackerAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrackerAssociation {
        val builtJavaResource = com.pulumi.aws.location.TrackerAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrackerAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Location Tracker Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.location.GeofenceCollection("example", {collectionName: "example"});
 * const exampleTracker = new aws.location.Tracker("example", {trackerName: "example"});
 * const exampleTrackerAssociation = new aws.location.TrackerAssociation("example", {
 *     consumerArn: example.collectionArn,
 *     trackerName: exampleTracker.trackerName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.location.GeofenceCollection("example", collection_name="example")
 * example_tracker = aws.location.Tracker("example", tracker_name="example")
 * example_tracker_association = aws.location.TrackerAssociation("example",
 *     consumer_arn=example.collection_arn,
 *     tracker_name=example_tracker.tracker_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Location.GeofenceCollection("example", new()
 *     {
 *         CollectionName = "example",
 *     });
 *     var exampleTracker = new Aws.Location.Tracker("example", new()
 *     {
 *         TrackerName = "example",
 *     });
 *     var exampleTrackerAssociation = new Aws.Location.TrackerAssociation("example", new()
 *     {
 *         ConsumerArn = example.CollectionArn,
 *         TrackerName = exampleTracker.TrackerName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/location"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := location.NewGeofenceCollection(ctx, "example", &location.GeofenceCollectionArgs{
 * 			CollectionName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTracker, err := location.NewTracker(ctx, "example", &location.TrackerArgs{
 * 			TrackerName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = location.NewTrackerAssociation(ctx, "example", &location.TrackerAssociationArgs{
 * 			ConsumerArn: example.CollectionArn,
 * 			TrackerName: exampleTracker.TrackerName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.GeofenceCollection;
 * import com.pulumi.aws.location.GeofenceCollectionArgs;
 * import com.pulumi.aws.location.Tracker;
 * import com.pulumi.aws.location.TrackerArgs;
 * import com.pulumi.aws.location.TrackerAssociation;
 * import com.pulumi.aws.location.TrackerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GeofenceCollection("example", GeofenceCollectionArgs.builder()
 *             .collectionName("example")
 *             .build());
 *         var exampleTracker = new Tracker("exampleTracker", TrackerArgs.builder()
 *             .trackerName("example")
 *             .build());
 *         var exampleTrackerAssociation = new TrackerAssociation("exampleTrackerAssociation", TrackerAssociationArgs.builder()
 *             .consumerArn(example.collectionArn())
 *             .trackerName(exampleTracker.trackerName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:location:GeofenceCollection
 *     properties:
 *       collectionName: example
 *   exampleTracker:
 *     type: aws:location:Tracker
 *     name: example
 *     properties:
 *       trackerName: example
 *   exampleTrackerAssociation:
 *     type: aws:location:TrackerAssociation
 *     name: example
 *     properties:
 *       consumerArn: ${example.collectionArn}
 *       trackerName: ${exampleTracker.trackerName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:
 * ```sh
 * $ pulumi import aws:location/trackerAssociation:TrackerAssociation example "tracker_name|consumer_arn"
 * ```
 */
public class TrackerAssociation internal constructor(
    override val javaResource: com.pulumi.aws.location.TrackerAssociation,
) : KotlinCustomResource(javaResource, TrackerAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
     */
    public val consumerArn: Output<String>
        get() = javaResource.consumerArn().applyValue({ args0 -> args0 })

    /**
     * The name of the tracker resource to be associated with a geofence collection.
     */
    public val trackerName: Output<String>
        get() = javaResource.trackerName().applyValue({ args0 -> args0 })
}

public object TrackerAssociationMapper : ResourceMapper<TrackerAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.location.TrackerAssociation::class == javaResource::class

    override fun map(javaResource: Resource): TrackerAssociation = TrackerAssociation(
        javaResource as
            com.pulumi.aws.location.TrackerAssociation,
    )
}

/**
 * @see [TrackerAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrackerAssociation].
 */
public suspend fun trackerAssociation(
    name: String,
    block: suspend TrackerAssociationResourceBuilder.() -> Unit,
): TrackerAssociation {
    val builder = TrackerAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrackerAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trackerAssociation(name: String): TrackerAssociation {
    val builder = TrackerAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
