@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetTrackerAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrackerAssociations.
 * @property trackerName Name of the tracker resource associated with a geofence collection.
 */
public data class GetTrackerAssociationsPlainArgs(
    public val trackerName: String,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetTrackerAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetTrackerAssociationsPlainArgs =
        com.pulumi.aws.location.inputs.GetTrackerAssociationsPlainArgs.builder()
            .trackerName(trackerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrackerAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetTrackerAssociationsPlainArgsBuilder internal constructor() {
    private var trackerName: String? = null

    /**
     * @param value Name of the tracker resource associated with a geofence collection.
     */
    @JvmName("ljnoheaysqtohduj")
    public suspend fun trackerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trackerName = mapped
    }

    internal fun build(): GetTrackerAssociationsPlainArgs = GetTrackerAssociationsPlainArgs(
        trackerName = trackerName ?: throw PulumiNullFieldException("trackerName"),
    )
}
