@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.PlaceIndexDataSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property intendedUse Specifies how the results of an operation will be stored by the caller. Valid values: `SingleUse`, `Storage`. Default: `SingleUse`.
 */
public data class PlaceIndexDataSourceConfigurationArgs(
    public val intendedUse: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.PlaceIndexDataSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.PlaceIndexDataSourceConfigurationArgs =
        com.pulumi.aws.location.inputs.PlaceIndexDataSourceConfigurationArgs.builder()
            .intendedUse(intendedUse?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlaceIndexDataSourceConfigurationArgs].
 */
@PulumiTagMarker
public class PlaceIndexDataSourceConfigurationArgsBuilder internal constructor() {
    private var intendedUse: Output<String>? = null

    /**
     * @param value Specifies how the results of an operation will be stored by the caller. Valid values: `SingleUse`, `Storage`. Default: `SingleUse`.
     */
    @JvmName("hvcrofclsydblgqd")
    public suspend fun intendedUse(`value`: Output<String>) {
        this.intendedUse = value
    }

    /**
     * @param value Specifies how the results of an operation will be stored by the caller. Valid values: `SingleUse`, `Storage`. Default: `SingleUse`.
     */
    @JvmName("xppepamnjejlehod")
    public suspend fun intendedUse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intendedUse = mapped
    }

    internal fun build(): PlaceIndexDataSourceConfigurationArgs =
        PlaceIndexDataSourceConfigurationArgs(
            intendedUse = intendedUse,
        )
}
