@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getGeofenceCollection.
 * @property collectionArn ARN for the geofence collection resource. Used when you need to specify a resource across all AWS.
 * @property collectionName
 * @property createTime Timestamp for when the geofence collection resource was created in ISO 8601 format.
 * @property description Optional description of the geofence collection resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
 * @property tags Key-value map of resource tags for the geofence collection.
 * @property updateTime Timestamp for when the geofence collection resource was last updated in ISO 8601 format.
 */
public data class GetGeofenceCollectionResult(
    public val collectionArn: String,
    public val collectionName: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val kmsKeyId: String,
    public val tags: Map<String, String>,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetGeofenceCollectionResult): GetGeofenceCollectionResult = GetGeofenceCollectionResult(
            collectionArn = javaType.collectionArn(),
            collectionName = javaType.collectionName(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateTime = javaType.updateTime(),
        )
    }
}
