@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getMap.
 * @property configurations List of configurations that specify the map tile style selected from a partner data provider.
 * @property createTime Timestamp for when the map resource was created in ISO 8601 format.
 * @property description Optional description for the map resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property mapArn ARN for the map resource.
 * @property mapName
 * @property tags Key-value map of resource tags for the map.
 * @property updateTime Timestamp for when the map resource was last updated in ISO 8601 format.
 */
public data class GetMapResult(
    public val configurations: List<GetMapConfiguration>,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val mapArn: String,
    public val mapName: String,
    public val tags: Map<String, String>,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetMapResult): GetMapResult =
            GetMapResult(
                configurations = javaType.configurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.location.kotlin.outputs.GetMapConfiguration.Companion.toKotlin(args0)
                    })
                }),
                createTime = javaType.createTime(),
                description = javaType.description(),
                id = javaType.id(),
                mapArn = javaType.mapArn(),
                mapName = javaType.mapName(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                updateTime = javaType.updateTime(),
            )
    }
}
