@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPlaceIndex.
 * @property createTime Timestamp for when the place index resource was created in ISO 8601 format.
 * @property dataSource Data provider of geospatial data.
 * @property dataSourceConfigurations List of configurations that specify data storage option for requesting Places.
 * @property description Optional description for the place index resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property indexArn ARN for the place index resource.
 * @property indexName
 * @property tags Key-value map of resource tags for the place index.
 * @property updateTime Timestamp for when the place index resource was last updated in ISO 8601 format.
 */
public data class GetPlaceIndexResult(
    public val createTime: String,
    public val dataSource: String,
    public val dataSourceConfigurations: List<GetPlaceIndexDataSourceConfiguration>,
    public val description: String,
    public val id: String,
    public val indexArn: String,
    public val indexName: String,
    public val tags: Map<String, String>,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetPlaceIndexResult): GetPlaceIndexResult = GetPlaceIndexResult(
            createTime = javaType.createTime(),
            dataSource = javaType.dataSource(),
            dataSourceConfigurations = javaType.dataSourceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.location.kotlin.outputs.GetPlaceIndexDataSourceConfiguration.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            id = javaType.id(),
            indexArn = javaType.indexArn(),
            indexName = javaType.indexName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateTime = javaType.updateTime(),
        )
    }
}
