@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getRouteCalculator.
 * @property calculatorArn ARN for the Route calculator resource. Use the ARN when you specify a resource across AWS.
 * @property calculatorName
 * @property createTime Timestamp for when the route calculator resource was created in ISO 8601 format.
 * @property dataSource Data provider of traffic and road network data.
 * @property description Optional description of the route calculator resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Key-value map of resource tags for the route calculator.
 * @property updateTime Timestamp for when the route calculator resource was last updated in ISO 8601 format.
 */
public data class GetRouteCalculatorResult(
    public val calculatorArn: String,
    public val calculatorName: String,
    public val createTime: String,
    public val dataSource: String,
    public val description: String,
    public val id: String,
    public val tags: Map<String, String>,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetRouteCalculatorResult): GetRouteCalculatorResult = GetRouteCalculatorResult(
            calculatorArn = javaType.calculatorArn(),
            calculatorName = javaType.calculatorName(),
            createTime = javaType.createTime(),
            dataSource = javaType.dataSource(),
            description = javaType.description(),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateTime = javaType.updateTime(),
        )
    }
}
