@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getTrackerAssociation.
 * @property consumerArn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property trackerName
 */
public data class GetTrackerAssociationResult(
    public val consumerArn: String,
    public val id: String,
    public val trackerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetTrackerAssociationResult): GetTrackerAssociationResult = GetTrackerAssociationResult(
            consumerArn = javaType.consumerArn(),
            id = javaType.id(),
            trackerName = javaType.trackerName(),
        )
    }
}
