@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrackerAssociations.
 * @property consumerArns List of geofence collection ARNs associated to the tracker resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property trackerName
 */
public data class GetTrackerAssociationsResult(
    public val consumerArns: List<String>,
    public val id: String,
    public val trackerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetTrackerAssociationsResult): GetTrackerAssociationsResult = GetTrackerAssociationsResult(
            consumerArns = javaType.consumerArns().map({ args0 -> args0 }),
            id = javaType.id(),
            trackerName = javaType.trackerName(),
        )
    }
}
