@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.kotlin.outputs.ApplicationDefinition
import com.pulumi.aws.m2.kotlin.outputs.ApplicationTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.m2.kotlin.outputs.ApplicationDefinition.Companion.toKotlin as applicationDefinitionToKotlin
import com.pulumi.aws.m2.kotlin.outputs.ApplicationTimeouts.Companion.toKotlin as applicationTimeoutsToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.m2.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Resource for managing an [AWS Mainframe Modernization Application](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.m2.Application("example", {
 *     name: "Example",
 *     engineType: "bluage",
 *     definition: {
 *         content: `{
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "${s3_source}/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * `,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.m2.Application("example",
 *     name="Example",
 *     engine_type="bluage",
 *     definition={
 *         "content": f"""{{
 *   "definition": {{
 *     "listeners": [
 *       {{
 *         "port": 8196,
 *         "type": "http"
 *       }}
 *     ],
 *     "ba-application": {{
 *       "app-location": "{s3_source}/PlanetsDemo-v1.zip"
 *     }}
 *   }},
 *   "source-locations": [
 *     {{
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {{
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }}
 *     }}
 *   ],
 *   "template-version": "2.0"
 * }}
 * """,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.M2.Application("example", new()
 *     {
 *         Name = "Example",
 *         EngineType = "bluage",
 *         Definition = new Aws.M2.Inputs.ApplicationDefinitionArgs
 *         {
 *             Content = @$"{{
 *   ""definition"": {{
 *     ""listeners"": [
 *       {{
 *         ""port"": 8196,
 *         ""type"": ""http""
 *       }}
 *     ],
 *     ""ba-application"": {{
 *       ""app-location"": ""{s3_source}/PlanetsDemo-v1.zip""
 *     }}
 *   }},
 *   ""source-locations"": [
 *     {{
 *       ""source-id"": ""s3-source"",
 *       ""source-type"": ""s3"",
 *       ""properties"": {{
 *         ""s3-bucket"": ""example-bucket"",
 *         ""s3-key-prefix"": ""v1""
 *       }}
 *     }}
 *   ],
 *   ""template-version"": ""2.0""
 * }}
 * ",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/m2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m2.NewApplication(ctx, "example", &m2.ApplicationArgs{
 * 			Name:       pulumi.String("Example"),
 * 			EngineType: pulumi.String("bluage"),
 * 			Definition: &m2.ApplicationDefinitionArgs{
 * 				Content: pulumi.Sprintf(`{
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "%v/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * `, s3_source),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.m2.Application;
 * import com.pulumi.aws.m2.ApplicationArgs;
 * import com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("Example")
 *             .engineType("bluage")
 *             .definition(ApplicationDefinitionArgs.builder()
 *                 .content("""
 * {
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "%s/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * ", s3_source))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:m2:Application
 *     properties:
 *       name: Example
 *       engineType: bluage
 *       definition:
 *         content: |+
 *           {
 *             "definition": {
 *               "listeners": [
 *                 {
 *                   "port": 8196,
 *                   "type": "http"
 *                 }
 *               ],
 *               "ba-application": {
 *                 "app-location": "${["s3-source"]}/PlanetsDemo-v1.zip"
 *               }
 *             },
 *             "source-locations": [
 *               {
 *                 "source-id": "s3-source",
 *                 "source-type": "s3",
 *                 "properties": {
 *                   "s3-bucket": "example-bucket",
 *                   "s3-key-prefix": "v1"
 *                 }
 *               }
 *             ],
 *             "template-version": "2.0"
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Application using the `01234567890abcdef012345678`. For example:
 * ```sh
 * $ pulumi import aws:m2/application:Application example 01234567890abcdef012345678
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.m2.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * Id of the Application.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * ARN of the Application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Current version of the application deployed.
     */
    public val currentVersion: Output<Int>
        get() = javaResource.currentVersion().applyValue({ args0 -> args0 })

    /**
     * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     */
    public val definition: Output<ApplicationDefinition>?
        get() = javaResource.definition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationDefinitionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Engine type must be `microfocus | bluage`.
     */
    public val engineType: Output<String>
        get() = javaResource.engineType().applyValue({ args0 -> args0 })

    /**
     * KMS Key to use for the Application.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique identifier of the application.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARN of role for application to use to access AWS resources.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ApplicationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.m2.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.m2.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
