@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.ApplicationArgs.builder
import com.pulumi.aws.m2.kotlin.inputs.ApplicationDefinitionArgs
import com.pulumi.aws.m2.kotlin.inputs.ApplicationDefinitionArgsBuilder
import com.pulumi.aws.m2.kotlin.inputs.ApplicationTimeoutsArgs
import com.pulumi.aws.m2.kotlin.inputs.ApplicationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an [AWS Mainframe Modernization Application](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.m2.Application("example", {
 *     name: "Example",
 *     engineType: "bluage",
 *     definition: {
 *         content: `{
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "${s3_source}/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * `,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.m2.Application("example",
 *     name="Example",
 *     engine_type="bluage",
 *     definition={
 *         "content": f"""{{
 *   "definition": {{
 *     "listeners": [
 *       {{
 *         "port": 8196,
 *         "type": "http"
 *       }}
 *     ],
 *     "ba-application": {{
 *       "app-location": "{s3_source}/PlanetsDemo-v1.zip"
 *     }}
 *   }},
 *   "source-locations": [
 *     {{
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {{
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }}
 *     }}
 *   ],
 *   "template-version": "2.0"
 * }}
 * """,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.M2.Application("example", new()
 *     {
 *         Name = "Example",
 *         EngineType = "bluage",
 *         Definition = new Aws.M2.Inputs.ApplicationDefinitionArgs
 *         {
 *             Content = @$"{{
 *   ""definition"": {{
 *     ""listeners"": [
 *       {{
 *         ""port"": 8196,
 *         ""type"": ""http""
 *       }}
 *     ],
 *     ""ba-application"": {{
 *       ""app-location"": ""{s3_source}/PlanetsDemo-v1.zip""
 *     }}
 *   }},
 *   ""source-locations"": [
 *     {{
 *       ""source-id"": ""s3-source"",
 *       ""source-type"": ""s3"",
 *       ""properties"": {{
 *         ""s3-bucket"": ""example-bucket"",
 *         ""s3-key-prefix"": ""v1""
 *       }}
 *     }}
 *   ],
 *   ""template-version"": ""2.0""
 * }}
 * ",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/m2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m2.NewApplication(ctx, "example", &m2.ApplicationArgs{
 * 			Name:       pulumi.String("Example"),
 * 			EngineType: pulumi.String("bluage"),
 * 			Definition: &m2.ApplicationDefinitionArgs{
 * 				Content: pulumi.Sprintf(`{
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "%v/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * `, s3_source),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.m2.Application;
 * import com.pulumi.aws.m2.ApplicationArgs;
 * import com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Application("example", ApplicationArgs.builder()
 *             .name("Example")
 *             .engineType("bluage")
 *             .definition(ApplicationDefinitionArgs.builder()
 *                 .content("""
 * {
 *   "definition": {
 *     "listeners": [
 *       {
 *         "port": 8196,
 *         "type": "http"
 *       }
 *     ],
 *     "ba-application": {
 *       "app-location": "%s/PlanetsDemo-v1.zip"
 *     }
 *   },
 *   "source-locations": [
 *     {
 *       "source-id": "s3-source",
 *       "source-type": "s3",
 *       "properties": {
 *         "s3-bucket": "example-bucket",
 *         "s3-key-prefix": "v1"
 *       }
 *     }
 *   ],
 *   "template-version": "2.0"
 * }
 * ", s3_source))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:m2:Application
 *     properties:
 *       name: Example
 *       engineType: bluage
 *       definition:
 *         content: |+
 *           {
 *             "definition": {
 *               "listeners": [
 *                 {
 *                   "port": 8196,
 *                   "type": "http"
 *                 }
 *               ],
 *               "ba-application": {
 *                 "app-location": "${["s3-source"]}/PlanetsDemo-v1.zip"
 *               }
 *             },
 *             "source-locations": [
 *               {
 *                 "source-id": "s3-source",
 *                 "source-type": "s3",
 *                 "properties": {
 *                   "s3-bucket": "example-bucket",
 *                   "s3-key-prefix": "v1"
 *                 }
 *               }
 *             ],
 *             "template-version": "2.0"
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Application using the `01234567890abcdef012345678`. For example:
 * ```sh
 * $ pulumi import aws:m2/application:Application example 01234567890abcdef012345678
 * ```
 * @property definition The application definition for this application. You can specify either inline JSON or an S3 bucket location.
 * @property description Description of the application.
 * @property engineType Engine type must be `microfocus | bluage`.
 * @property kmsKeyId KMS Key to use for the Application.
 * @property name Unique identifier of the application.
 * The following arguments are optional:
 * @property roleArn ARN of role for application to use to access AWS resources.
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class ApplicationArgs(
    public val definition: Output<ApplicationDefinitionArgs>? = null,
    public val description: Output<String>? = null,
    public val engineType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ApplicationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.m2.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.m2.ApplicationArgs =
        com.pulumi.aws.m2.ApplicationArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var definition: Output<ApplicationDefinitionArgs>? = null

    private var description: Output<String>? = null

    private var engineType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ApplicationTimeoutsArgs>? = null

    /**
     * @param value The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     */
    @JvmName("clcpeptfhahsnlgg")
    public suspend fun definition(`value`: Output<ApplicationDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("brgnhvqtunqddktw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Engine type must be `microfocus | bluage`.
     */
    @JvmName("vjurcdxpxdwxykdf")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value KMS Key to use for the Application.
     */
    @JvmName("sidglvbuvqswhpwa")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Unique identifier of the application.
     * The following arguments are optional:
     */
    @JvmName("fbaceojfopcgajnw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of role for application to use to access AWS resources.
     */
    @JvmName("mdhieepdxacrwjga")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ttyarbvujouiyxpl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("soavtxptmdtepwds")
    public suspend fun timeouts(`value`: Output<ApplicationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     */
    @JvmName("cxulsyotbfujvvao")
    public suspend fun definition(`value`: ApplicationDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     */
    @JvmName("gjioxlqgxcdeaqjs")
    public suspend fun definition(argument: suspend ApplicationDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("cobjbrccnurrqrjf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Engine type must be `microfocus | bluage`.
     */
    @JvmName("ooxwbwgdagolkctt")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value KMS Key to use for the Application.
     */
    @JvmName("niiesdwcxcccshuo")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Unique identifier of the application.
     * The following arguments are optional:
     */
    @JvmName("kmdjirytffravfkd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ARN of role for application to use to access AWS resources.
     */
    @JvmName("dqawjuykaxetagml")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kdjpvamwpiwgnuuw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ifpgfihhrnmcgjia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwaqahyfepyhnsdy")
    public suspend fun timeouts(`value`: ApplicationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mpinmlmxsjiiuyds")
    public suspend fun timeouts(argument: suspend ApplicationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        definition = definition,
        description = description,
        engineType = engineType,
        kmsKeyId = kmsKeyId,
        name = name,
        roleArn = roleArn,
        tags = tags,
        timeouts = timeouts,
    )
}
