@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.kotlin.outputs.DeploymentTimeouts
import com.pulumi.aws.m2.kotlin.outputs.DeploymentTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.aws.m2.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * Resource for managing an [AWS Mainframe Modernization Deployment&#46;](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2-deploy.html)
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.m2.Deployment("test", {
 *     environmentId: "01234567890abcdef012345678",
 *     applicationId: "34567890abcdef012345678012",
 *     applicationVersion: 1,
 *     start: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.m2.Deployment("test",
 *     environment_id="01234567890abcdef012345678",
 *     application_id="34567890abcdef012345678012",
 *     application_version=1,
 *     start=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.M2.Deployment("test", new()
 *     {
 *         EnvironmentId = "01234567890abcdef012345678",
 *         ApplicationId = "34567890abcdef012345678012",
 *         ApplicationVersion = 1,
 *         Start = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/m2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m2.NewDeployment(ctx, "test", &m2.DeploymentArgs{
 * 			EnvironmentId:      pulumi.String("01234567890abcdef012345678"),
 * 			ApplicationId:      pulumi.String("34567890abcdef012345678012"),
 * 			ApplicationVersion: pulumi.Int(1),
 * 			Start:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.m2.Deployment;
 * import com.pulumi.aws.m2.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Deployment("test", DeploymentArgs.builder()
 *             .environmentId("01234567890abcdef012345678")
 *             .applicationId("34567890abcdef012345678012")
 *             .applicationVersion(1)
 *             .start(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Deployment
 *     properties:
 *       environmentId: 01234567890abcdef012345678
 *       applicationId: 34567890abcdef012345678012
 *       applicationVersion: 1
 *       start: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Deployment using the `APPLICATION-ID,DEPLOYMENT-ID`. For example:
 * ```sh
 * $ pulumi import aws:m2/deployment:Deployment example APPLICATION-ID,DEPLOYMENT-ID
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.aws.m2.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * Application to deploy.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Version to application to deploy
     */
    public val applicationVersion: Output<Int>
        get() = javaResource.applicationVersion().applyValue({ args0 -> args0 })

    public val deploymentId: Output<String>
        get() = javaResource.deploymentId().applyValue({ args0 -> args0 })

    /**
     * Environment to deploy application to.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    public val forceStop: Output<Boolean>?
        get() = javaResource.forceStop().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Start the application once deployed.
     */
    public val start: Output<Boolean>
        get() = javaResource.start().applyValue({ args0 -> args0 })

    public val timeouts: Output<DeploymentTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.m2.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.aws.m2.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
