@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.DeploymentArgs.builder
import com.pulumi.aws.m2.kotlin.inputs.DeploymentTimeoutsArgs
import com.pulumi.aws.m2.kotlin.inputs.DeploymentTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an [AWS Mainframe Modernization Deployment&#46;](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2-deploy.html)
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.m2.Deployment("test", {
 *     environmentId: "01234567890abcdef012345678",
 *     applicationId: "34567890abcdef012345678012",
 *     applicationVersion: 1,
 *     start: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.m2.Deployment("test",
 *     environment_id="01234567890abcdef012345678",
 *     application_id="34567890abcdef012345678012",
 *     application_version=1,
 *     start=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.M2.Deployment("test", new()
 *     {
 *         EnvironmentId = "01234567890abcdef012345678",
 *         ApplicationId = "34567890abcdef012345678012",
 *         ApplicationVersion = 1,
 *         Start = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/m2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m2.NewDeployment(ctx, "test", &m2.DeploymentArgs{
 * 			EnvironmentId:      pulumi.String("01234567890abcdef012345678"),
 * 			ApplicationId:      pulumi.String("34567890abcdef012345678012"),
 * 			ApplicationVersion: pulumi.Int(1),
 * 			Start:              pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.m2.Deployment;
 * import com.pulumi.aws.m2.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Deployment("test", DeploymentArgs.builder()
 *             .environmentId("01234567890abcdef012345678")
 *             .applicationId("34567890abcdef012345678012")
 *             .applicationVersion(1)
 *             .start(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Deployment
 *     properties:
 *       environmentId: 01234567890abcdef012345678
 *       applicationId: 34567890abcdef012345678012
 *       applicationVersion: 1
 *       start: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Deployment using the `APPLICATION-ID,DEPLOYMENT-ID`. For example:
 * ```sh
 * $ pulumi import aws:m2/deployment:Deployment example APPLICATION-ID,DEPLOYMENT-ID
 * ```
 * @property applicationId Application to deploy.
 * @property applicationVersion Version to application to deploy
 * @property environmentId Environment to deploy application to.
 * @property forceStop
 * @property start Start the application once deployed.
 * @property timeouts
 */
public data class DeploymentArgs(
    public val applicationId: Output<String>? = null,
    public val applicationVersion: Output<Int>? = null,
    public val environmentId: Output<String>? = null,
    public val forceStop: Output<Boolean>? = null,
    public val start: Output<Boolean>? = null,
    public val timeouts: Output<DeploymentTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.m2.DeploymentArgs> {
    override fun toJava(): com.pulumi.aws.m2.DeploymentArgs =
        com.pulumi.aws.m2.DeploymentArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .applicationVersion(applicationVersion?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .forceStop(forceStop?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var applicationVersion: Output<Int>? = null

    private var environmentId: Output<String>? = null

    private var forceStop: Output<Boolean>? = null

    private var start: Output<Boolean>? = null

    private var timeouts: Output<DeploymentTimeoutsArgs>? = null

    /**
     * @param value Application to deploy.
     */
    @JvmName("wifopoemcvvynclw")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Version to application to deploy
     */
    @JvmName("bvdkucutnlmtrqpn")
    public suspend fun applicationVersion(`value`: Output<Int>) {
        this.applicationVersion = value
    }

    /**
     * @param value Environment to deploy application to.
     */
    @JvmName("xryvyvwpdddbqmty")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value
     */
    @JvmName("uvmnpfqmevefbdcv")
    public suspend fun forceStop(`value`: Output<Boolean>) {
        this.forceStop = value
    }

    /**
     * @param value Start the application once deployed.
     */
    @JvmName("tttduxkwqwjcwxuu")
    public suspend fun start(`value`: Output<Boolean>) {
        this.start = value
    }

    /**
     * @param value
     */
    @JvmName("cxuodaycwugcwgyl")
    public suspend fun timeouts(`value`: Output<DeploymentTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Application to deploy.
     */
    @JvmName("fgmnukxmpsjbphcv")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Version to application to deploy
     */
    @JvmName("nvfcrymxpteodigw")
    public suspend fun applicationVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationVersion = mapped
    }

    /**
     * @param value Environment to deploy application to.
     */
    @JvmName("xliwfhrbqsfxjmdb")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value
     */
    @JvmName("foaavvhkoujluxpu")
    public suspend fun forceStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceStop = mapped
    }

    /**
     * @param value Start the application once deployed.
     */
    @JvmName("siqterfmatnkrivi")
    public suspend fun start(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwnljwqgtnjapnfw")
    public suspend fun timeouts(`value`: DeploymentTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("syjkbmgvmodykmfb")
    public suspend fun timeouts(argument: suspend DeploymentTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        applicationId = applicationId,
        applicationVersion = applicationVersion,
        environmentId = environmentId,
        forceStop = forceStop,
        start = start,
        timeouts = timeouts,
    )
}
