@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.kotlin.outputs.EnvironmentHighAvailabilityConfig
import com.pulumi.aws.m2.kotlin.outputs.EnvironmentStorageConfiguration
import com.pulumi.aws.m2.kotlin.outputs.EnvironmentTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.m2.kotlin.outputs.EnvironmentHighAvailabilityConfig.Companion.toKotlin as environmentHighAvailabilityConfigToKotlin
import com.pulumi.aws.m2.kotlin.outputs.EnvironmentStorageConfiguration.Companion.toKotlin as environmentStorageConfigurationToKotlin
import com.pulumi.aws.m2.kotlin.outputs.EnvironmentTimeouts.Companion.toKotlin as environmentTimeoutsToKotlin

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.aws.m2.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Resource for managing an [AWS Mainframe Modernization Environment](https://docs.aws.amazon.com/m2/latest/userguide/environments-m2.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 * ```
 * <!--End PulumiCodeChooser -->
 * ### High Availability
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       highAvailabilityConfig:
 *         desiredCapacity: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### EFS Filesystem
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       storageConfiguration:
 *         efs:
 *           fileSystemId: fs-01234567890abcdef
 *           mountPoint: /m2/mount/example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### FSX Filesystem
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       storageConfiguration:
 *         fsx:
 *           fileSystemId: fs-01234567890abcdef
 *           mountPoint: /m2/mount/example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Environment using the `01234567890abcdef012345678`. For example:
 * ```sh
 * $ pulumi import aws:m2/environment:Environment example 01234567890abcdef012345678
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.aws.m2.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    public val applyChangesDuringMaintenanceWindow: Output<Boolean>?
        get() = javaResource.applyChangesDuringMaintenanceWindow().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * ARN of the Environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Engine type must be `microfocus` or `bluage`.
     */
    public val engineType: Output<String>
        get() = javaResource.engineType().applyValue({ args0 -> args0 })

    /**
     * The specific version of the engine for the Environment.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The id of the Environment.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Force update the environment even if applications are running.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val highAvailabilityConfig: Output<EnvironmentHighAvailabilityConfig>?
        get() = javaResource.highAvailabilityConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> environmentHighAvailabilityConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * M2 Instance Type.
     * The following arguments are optional:
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * ARN of the KMS key to use for the Environment.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN of the load balancer created by the Environment.
     */
    public val loadBalancerArn: Output<String>
        get() = javaResource.loadBalancerArn().applyValue({ args0 -> args0 })

    /**
     * Name of the runtime environment. Must be unique within the account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Allow applications deployed to this environment to be publicly accessible.
     */
    public val publiclyAccessible: Output<Boolean>
        get() = javaResource.publiclyAccessible().applyValue({ args0 -> args0 })

    /**
     * List of security group ids.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val storageConfiguration: Output<EnvironmentStorageConfiguration>?
        get() = javaResource.storageConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> environmentStorageConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of subnet ids to deploy environment to.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<EnvironmentTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    environmentTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.m2.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.aws.m2.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
