@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin

import com.pulumi.aws.m2.EnvironmentArgs.builder
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentHighAvailabilityConfigArgs
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentHighAvailabilityConfigArgsBuilder
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentStorageConfigurationArgs
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentStorageConfigurationArgsBuilder
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentTimeoutsArgs
import com.pulumi.aws.m2.kotlin.inputs.EnvironmentTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an [AWS Mainframe Modernization Environment](https://docs.aws.amazon.com/m2/latest/userguide/environments-m2.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 * ```
 * <!--End PulumiCodeChooser -->
 * ### High Availability
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       highAvailabilityConfig:
 *         desiredCapacity: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### EFS Filesystem
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       storageConfiguration:
 *         efs:
 *           fileSystemId: fs-01234567890abcdef
 *           mountPoint: /m2/mount/example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### FSX Filesystem
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:m2:Environment
 *     properties:
 *       name: test-env
 *       engineType: bluage
 *       instanceType: M2.m5.large
 *       securityGroups:
 *         - sg-01234567890abcdef
 *       subnetIds:
 *         - subnet-01234567890abcdef
 *         - subnet-01234567890abcdea
 *       storageConfiguration:
 *         fsx:
 *           fileSystemId: fs-01234567890abcdef
 *           mountPoint: /m2/mount/example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Mainframe Modernization Environment using the `01234567890abcdef012345678`. For example:
 * ```sh
 * $ pulumi import aws:m2/environment:Environment example 01234567890abcdef012345678
 * ```
 * @property applyChangesDuringMaintenanceWindow
 * @property description
 * @property engineType Engine type must be `microfocus` or `bluage`.
 * @property engineVersion The specific version of the engine for the Environment.
 * @property forceUpdate Force update the environment even if applications are running.
 * @property highAvailabilityConfig
 * @property instanceType M2 Instance Type.
 * The following arguments are optional:
 * @property kmsKeyId ARN of the KMS key to use for the Environment.
 * @property name Name of the runtime environment. Must be unique within the account.
 * @property preferredMaintenanceWindow Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
 * @property publiclyAccessible Allow applications deployed to this environment to be publicly accessible.
 * @property securityGroupIds List of security group ids.
 * @property storageConfiguration
 * @property subnetIds List of subnet ids to deploy environment to.
 * @property tags Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class EnvironmentArgs(
    public val applyChangesDuringMaintenanceWindow: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val engineType: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val forceUpdate: Output<Boolean>? = null,
    public val highAvailabilityConfig: Output<EnvironmentHighAvailabilityConfigArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageConfiguration: Output<EnvironmentStorageConfigurationArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<EnvironmentTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.m2.EnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.m2.EnvironmentArgs =
        com.pulumi.aws.m2.EnvironmentArgs.builder()
            .applyChangesDuringMaintenanceWindow(
                applyChangesDuringMaintenanceWindow?.applyValue({ args0 ->
                    args0
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .forceUpdate(forceUpdate?.applyValue({ args0 -> args0 }))
            .highAvailabilityConfig(
                highAvailabilityConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageConfiguration(
                storageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var applyChangesDuringMaintenanceWindow: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var engineType: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var forceUpdate: Output<Boolean>? = null

    private var highAvailabilityConfig: Output<EnvironmentHighAvailabilityConfigArgs>? = null

    private var instanceType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageConfiguration: Output<EnvironmentStorageConfigurationArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<EnvironmentTimeoutsArgs>? = null

    /**
     * @param value
     */
    @JvmName("meavfknvkerhuvnu")
    public suspend fun applyChangesDuringMaintenanceWindow(`value`: Output<Boolean>) {
        this.applyChangesDuringMaintenanceWindow = value
    }

    /**
     * @param value
     */
    @JvmName("llhoakuoehagmnfq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Engine type must be `microfocus` or `bluage`.
     */
    @JvmName("yducoltfmjvdpjmc")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value The specific version of the engine for the Environment.
     */
    @JvmName("qugxrkpgsjtcuxtx")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Force update the environment even if applications are running.
     */
    @JvmName("othnkmmusnqjtmlu")
    public suspend fun forceUpdate(`value`: Output<Boolean>) {
        this.forceUpdate = value
    }

    /**
     * @param value
     */
    @JvmName("mqnxykoffcvbohjx")
    public suspend fun highAvailabilityConfig(`value`: Output<EnvironmentHighAvailabilityConfigArgs>) {
        this.highAvailabilityConfig = value
    }

    /**
     * @param value M2 Instance Type.
     * The following arguments are optional:
     */
    @JvmName("bxwcgqafxbtvngtl")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value ARN of the KMS key to use for the Environment.
     */
    @JvmName("mpsqnklovjoqthov")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the runtime environment. Must be unique within the account.
     */
    @JvmName("sxhblkvqbcqrtwfd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
     */
    @JvmName("hhycujpefoqcfypk")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Allow applications deployed to this environment to be publicly accessible.
     */
    @JvmName("wqvveovwjofiicjw")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value List of security group ids.
     */
    @JvmName("avghyjwcuswfhpsq")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("xladpbkgawjrtftm")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group ids.
     */
    @JvmName("udtakelyhhcvytbs")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("danelpinewsdtlqb")
    public suspend fun storageConfiguration(`value`: Output<EnvironmentStorageConfigurationArgs>) {
        this.storageConfiguration = value
    }

    /**
     * @param value List of subnet ids to deploy environment to.
     */
    @JvmName("ahktikwbjqtlylkw")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("fthwxfykymtrhhqo")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of subnet ids to deploy environment to.
     */
    @JvmName("wehloijmbucdcmyf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("diinrxrnocrdpifl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("kbqoxkogrdodoxrs")
    public suspend fun timeouts(`value`: Output<EnvironmentTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value
     */
    @JvmName("bkgdncouinaierip")
    public suspend fun applyChangesDuringMaintenanceWindow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyChangesDuringMaintenanceWindow = mapped
    }

    /**
     * @param value
     */
    @JvmName("conrlykhdtiifajf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Engine type must be `microfocus` or `bluage`.
     */
    @JvmName("mjtanduokkybntkx")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The specific version of the engine for the Environment.
     */
    @JvmName("rfadojjmhaerapxo")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Force update the environment even if applications are running.
     */
    @JvmName("vjjmtsopstvewmtl")
    public suspend fun forceUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdate = mapped
    }

    /**
     * @param value
     */
    @JvmName("tvgomxglrqcjolte")
    public suspend fun highAvailabilityConfig(`value`: EnvironmentHighAvailabilityConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailabilityConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bhbrqsyqbtcraxmh")
    public suspend fun highAvailabilityConfig(argument: suspend EnvironmentHighAvailabilityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentHighAvailabilityConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.highAvailabilityConfig = mapped
    }

    /**
     * @param value M2 Instance Type.
     * The following arguments are optional:
     */
    @JvmName("hrjuqhskrxdyssxl")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value ARN of the KMS key to use for the Environment.
     */
    @JvmName("soojifalvnuerciu")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the runtime environment. Must be unique within the account.
     */
    @JvmName("rklmdmrufcegliiw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
     */
    @JvmName("wnpkkpnmbxemrgnc")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Allow applications deployed to this environment to be publicly accessible.
     */
    @JvmName("jqykubbxnqufuyvk")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value List of security group ids.
     */
    @JvmName("jehobjgujqhivowf")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of security group ids.
     */
    @JvmName("nhjnfnoeyssgudjm")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("wfilmsfqdhcnrjiy")
    public suspend fun storageConfiguration(`value`: EnvironmentStorageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xarivqehicrgcfay")
    public suspend fun storageConfiguration(argument: suspend EnvironmentStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentStorageConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageConfiguration = mapped
    }

    /**
     * @param value List of subnet ids to deploy environment to.
     */
    @JvmName("idkaxukwqdghwyhi")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of subnet ids to deploy environment to.
     */
    @JvmName("tbcgmttactmfeymx")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cmfnktnktmoxtrfy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tjrxdanmuuqcdkde")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("bobcxaghldprayil")
    public suspend fun timeouts(`value`: EnvironmentTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qqchgvcnrqlydkpr")
    public suspend fun timeouts(argument: suspend EnvironmentTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        applyChangesDuringMaintenanceWindow = applyChangesDuringMaintenanceWindow,
        description = description,
        engineType = engineType,
        engineVersion = engineVersion,
        forceUpdate = forceUpdate,
        highAvailabilityConfig = highAvailabilityConfig,
        instanceType = instanceType,
        kmsKeyId = kmsKeyId,
        name = name,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        publiclyAccessible = publiclyAccessible,
        securityGroupIds = securityGroupIds,
        storageConfiguration = storageConfiguration,
        subnetIds = subnetIds,
        tags = tags,
        timeouts = timeouts,
    )
}
