@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.inputs

import com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content JSON application definition. Either this or `s3_location` must be specified.
 * @property s3Location Location of the application definition in S3. Either this or `content` must be specified.
 */
public data class ApplicationDefinitionArgs(
    public val content: Output<String>? = null,
    public val s3Location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs =
        com.pulumi.aws.m2.inputs.ApplicationDefinitionArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .s3Location(s3Location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationDefinitionArgs].
 */
@PulumiTagMarker
public class ApplicationDefinitionArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var s3Location: Output<String>? = null

    /**
     * @param value JSON application definition. Either this or `s3_location` must be specified.
     */
    @JvmName("mecehkxmiimfidkp")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Location of the application definition in S3. Either this or `content` must be specified.
     */
    @JvmName("qpoqwjrxkpbyfjnj")
    public suspend fun s3Location(`value`: Output<String>) {
        this.s3Location = value
    }

    /**
     * @param value JSON application definition. Either this or `s3_location` must be specified.
     */
    @JvmName("rkfxglbtugtekflx")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Location of the application definition in S3. Either this or `content` must be specified.
     */
    @JvmName("awctquabckinxytf")
    public suspend fun s3Location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Location = mapped
    }

    internal fun build(): ApplicationDefinitionArgs = ApplicationDefinitionArgs(
        content = content,
        s3Location = s3Location,
    )
}
