@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.inputs

import com.pulumi.aws.m2.inputs.EnvironmentHighAvailabilityConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property desiredCapacity Desired number of instances for the Environment.
 */
public data class EnvironmentHighAvailabilityConfigArgs(
    public val desiredCapacity: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.m2.inputs.EnvironmentHighAvailabilityConfigArgs> {
    override fun toJava(): com.pulumi.aws.m2.inputs.EnvironmentHighAvailabilityConfigArgs =
        com.pulumi.aws.m2.inputs.EnvironmentHighAvailabilityConfigArgs.builder()
            .desiredCapacity(desiredCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentHighAvailabilityConfigArgs].
 */
@PulumiTagMarker
public class EnvironmentHighAvailabilityConfigArgsBuilder internal constructor() {
    private var desiredCapacity: Output<Int>? = null

    /**
     * @param value Desired number of instances for the Environment.
     */
    @JvmName("xvafqenaterxffsw")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value Desired number of instances for the Environment.
     */
    @JvmName("fpgbfpmuhgoxnjpp")
    public suspend fun desiredCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    internal fun build(): EnvironmentHighAvailabilityConfigArgs =
        EnvironmentHighAvailabilityConfigArgs(
            desiredCapacity = desiredCapacity ?: throw PulumiNullFieldException("desiredCapacity"),
        )
}
