@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.inputs

import com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efs
 * @property fsx
 */
public data class EnvironmentStorageConfigurationArgs(
    public val efs: Output<EnvironmentStorageConfigurationEfsArgs>? = null,
    public val fsx: Output<EnvironmentStorageConfigurationFsxArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationArgs =
        com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationArgs.builder()
            .efs(efs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fsx(fsx?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EnvironmentStorageConfigurationArgs].
 */
@PulumiTagMarker
public class EnvironmentStorageConfigurationArgsBuilder internal constructor() {
    private var efs: Output<EnvironmentStorageConfigurationEfsArgs>? = null

    private var fsx: Output<EnvironmentStorageConfigurationFsxArgs>? = null

    /**
     * @param value
     */
    @JvmName("vxpnsykbmnweeigf")
    public suspend fun efs(`value`: Output<EnvironmentStorageConfigurationEfsArgs>) {
        this.efs = value
    }

    /**
     * @param value
     */
    @JvmName("ybokrkimpknvkqvw")
    public suspend fun fsx(`value`: Output<EnvironmentStorageConfigurationFsxArgs>) {
        this.fsx = value
    }

    /**
     * @param value
     */
    @JvmName("iixjdhnplmukqsdw")
    public suspend fun efs(`value`: EnvironmentStorageConfigurationEfsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bphpwytksujhelmw")
    public suspend fun efs(argument: suspend EnvironmentStorageConfigurationEfsArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentStorageConfigurationEfsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.efs = mapped
    }

    /**
     * @param value
     */
    @JvmName("buftxutthvmdgsfn")
    public suspend fun fsx(`value`: EnvironmentStorageConfigurationFsxArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsx = mapped
    }

    /**
     * @param argument
     */
    @JvmName("etgdnrgrpqguyeai")
    public suspend fun fsx(argument: suspend EnvironmentStorageConfigurationFsxArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentStorageConfigurationFsxArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fsx = mapped
    }

    internal fun build(): EnvironmentStorageConfigurationArgs = EnvironmentStorageConfigurationArgs(
        efs = efs,
        fsx = fsx,
    )
}
