@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.inputs

import com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationEfsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemId Id of the EFS filesystem to mount.
 * @property mountPoint Path to mount the filesystem on, must start with `/m2/mount/`.
 */
public data class EnvironmentStorageConfigurationEfsArgs(
    public val fileSystemId: Output<String>,
    public val mountPoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationEfsArgs> {
    override fun toJava(): com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationEfsArgs =
        com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationEfsArgs.builder()
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 }))
            .mountPoint(mountPoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentStorageConfigurationEfsArgs].
 */
@PulumiTagMarker
public class EnvironmentStorageConfigurationEfsArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var mountPoint: Output<String>? = null

    /**
     * @param value Id of the EFS filesystem to mount.
     */
    @JvmName("kkivrgimlmvplcqg")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value Path to mount the filesystem on, must start with `/m2/mount/`.
     */
    @JvmName("uiksfldgrrxfofbi")
    public suspend fun mountPoint(`value`: Output<String>) {
        this.mountPoint = value
    }

    /**
     * @param value Id of the EFS filesystem to mount.
     */
    @JvmName("clstwsbiwhdabxmh")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value Path to mount the filesystem on, must start with `/m2/mount/`.
     */
    @JvmName("bmyjwixkobqfoltf")
    public suspend fun mountPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoint = mapped
    }

    internal fun build(): EnvironmentStorageConfigurationEfsArgs =
        EnvironmentStorageConfigurationEfsArgs(
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
            mountPoint = mountPoint ?: throw PulumiNullFieldException("mountPoint"),
        )
}
