@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.inputs

import com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationFsxArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemId Id of the FSX filesystem to mount.
 * @property mountPoint Path to mount the filesystem on, must start with `/m2/mount/`.
 */
public data class EnvironmentStorageConfigurationFsxArgs(
    public val fileSystemId: Output<String>,
    public val mountPoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationFsxArgs> {
    override fun toJava(): com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationFsxArgs =
        com.pulumi.aws.m2.inputs.EnvironmentStorageConfigurationFsxArgs.builder()
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 }))
            .mountPoint(mountPoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentStorageConfigurationFsxArgs].
 */
@PulumiTagMarker
public class EnvironmentStorageConfigurationFsxArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var mountPoint: Output<String>? = null

    /**
     * @param value Id of the FSX filesystem to mount.
     */
    @JvmName("issuwagotqqqkucm")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value Path to mount the filesystem on, must start with `/m2/mount/`.
     */
    @JvmName("bbgnrahucciuyaho")
    public suspend fun mountPoint(`value`: Output<String>) {
        this.mountPoint = value
    }

    /**
     * @param value Id of the FSX filesystem to mount.
     */
    @JvmName("ptvyatcfnsfdbhdc")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value Path to mount the filesystem on, must start with `/m2/mount/`.
     */
    @JvmName("pgisworiwdkcuhuo")
    public suspend fun mountPoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoint = mapped
    }

    internal fun build(): EnvironmentStorageConfigurationFsxArgs =
        EnvironmentStorageConfigurationFsxArgs(
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
            mountPoint = mountPoint ?: throw PulumiNullFieldException("mountPoint"),
        )
}
