@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content JSON application definition. Either this or `s3_location` must be specified.
 * @property s3Location Location of the application definition in S3. Either this or `content` must be specified.
 */
public data class ApplicationDefinition(
    public val content: String? = null,
    public val s3Location: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.m2.outputs.ApplicationDefinition): ApplicationDefinition = ApplicationDefinition(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            s3Location = javaType.s3Location().map({ args0 -> args0 }).orElse(null),
        )
    }
}
