@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fileSystemId Id of the EFS filesystem to mount.
 * @property mountPoint Path to mount the filesystem on, must start with `/m2/mount/`.
 */
public data class EnvironmentStorageConfigurationEfs(
    public val fileSystemId: String,
    public val mountPoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.m2.outputs.EnvironmentStorageConfigurationEfs): EnvironmentStorageConfigurationEfs = EnvironmentStorageConfigurationEfs(
            fileSystemId = javaType.fileSystemId(),
            mountPoint = javaType.mountPoint(),
        )
    }
}
