@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.m2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fileSystemId Id of the FSX filesystem to mount.
 * @property mountPoint Path to mount the filesystem on, must start with `/m2/mount/`.
 */
public data class EnvironmentStorageConfigurationFsx(
    public val fileSystemId: String,
    public val mountPoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.m2.outputs.EnvironmentStorageConfigurationFsx): EnvironmentStorageConfigurationFsx = EnvironmentStorageConfigurationFsx(
            fileSystemId = javaType.fileSystemId(),
            mountPoint = javaType.mountPoint(),
        )
    }
}
