@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CustomDataIdentifier].
 */
@PulumiTagMarker
public class CustomDataIdentifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDataIdentifierArgs = CustomDataIdentifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDataIdentifierArgsBuilder.() -> Unit) {
        val builder = CustomDataIdentifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomDataIdentifier {
        val builtJavaResource = com.pulumi.aws.macie.CustomDataIdentifier(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomDataIdentifier(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [AWS Macie Custom Data Identifier](https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleCustomDataIdentifier = new aws.macie.CustomDataIdentifier("example", {
 *     name: "NAME OF CUSTOM DATA IDENTIFIER",
 *     regex: "[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *     description: "DESCRIPTION",
 *     maximumMatchDistance: 10,
 *     keywords: ["keyword"],
 *     ignoreWords: ["ignore"],
 * }, {
 *     dependsOn: [test],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_custom_data_identifier = aws.macie.CustomDataIdentifier("example",
 *     name="NAME OF CUSTOM DATA IDENTIFIER",
 *     regex="[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *     description="DESCRIPTION",
 *     maximum_match_distance=10,
 *     keywords=["keyword"],
 *     ignore_words=["ignore"],
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleCustomDataIdentifier = new Aws.Macie.CustomDataIdentifier("example", new()
 *     {
 *         Name = "NAME OF CUSTOM DATA IDENTIFIER",
 *         Regex = "[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *         Description = "DESCRIPTION",
 *         MaximumMatchDistance = 10,
 *         Keywords = new[]
 *         {
 *             "keyword",
 *         },
 *         IgnoreWords = new[]
 *         {
 *             "ignore",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie.NewCustomDataIdentifier(ctx, "example", &macie.CustomDataIdentifierArgs{
 * 			Name:                 pulumi.String("NAME OF CUSTOM DATA IDENTIFIER"),
 * 			Regex:                pulumi.String("[0-9]{3}-[0-9]{2}-[0-9]{4}"),
 * 			Description:          pulumi.String("DESCRIPTION"),
 * 			MaximumMatchDistance: pulumi.Int(10),
 * 			Keywords: pulumi.StringArray{
 * 				pulumi.String("keyword"),
 * 			},
 * 			IgnoreWords: pulumi.StringArray{
 * 				pulumi.String("ignore"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			test,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.CustomDataIdentifier;
 * import com.pulumi.aws.macie.CustomDataIdentifierArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleCustomDataIdentifier = new CustomDataIdentifier("exampleCustomDataIdentifier", CustomDataIdentifierArgs.builder()
 *             .name("NAME OF CUSTOM DATA IDENTIFIER")
 *             .regex("[0-9]{3}-[0-9]{2}-[0-9]{4}")
 *             .description("DESCRIPTION")
 *             .maximumMatchDistance(10)
 *             .keywords("keyword")
 *             .ignoreWords("ignore")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleCustomDataIdentifier:
 *     type: aws:macie:CustomDataIdentifier
 *     name: example
 *     properties:
 *       name: NAME OF CUSTOM DATA IDENTIFIER
 *       regex: '[0-9]{3}-[0-9]{2}-[0-9]{4}'
 *       description: DESCRIPTION
 *       maximumMatchDistance: 10
 *       keywords:
 *         - keyword
 *       ignoreWords:
 *         - ignore
 *     options:
 *       dependson:
 *         - ${test}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_custom_data_identifier` using the id. For example:
 * ```sh
 * $ pulumi import aws:macie/customDataIdentifier:CustomDataIdentifier example abcd1
 * ```
 */
public class CustomDataIdentifier internal constructor(
    override val javaResource: com.pulumi.aws.macie.CustomDataIdentifier,
) : KotlinCustomResource(javaResource, CustomDataIdentifierMapper) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time, in UTC and extended RFC 3339 format, when the Amazon Macie account was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A custom description of the custom data identifier. The description can contain as many as 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    public val ignoreWords: Output<List<String>>?
        get() = javaResource.ignoreWords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    public val keywords: Output<List<String>>?
        get() = javaResource.keywords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     */
    public val maximumMatchDistance: Output<Int>
        get() = javaResource.maximumMatchDistance().applyValue({ args0 -> args0 })

    /**
     * A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    public val regex: Output<String>?
        get() = javaResource.regex().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CustomDataIdentifierMapper : ResourceMapper<CustomDataIdentifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie.CustomDataIdentifier::class == javaResource::class

    override fun map(javaResource: Resource): CustomDataIdentifier = CustomDataIdentifier(
        javaResource
            as com.pulumi.aws.macie.CustomDataIdentifier,
    )
}

/**
 * @see [CustomDataIdentifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDataIdentifier].
 */
public suspend fun customDataIdentifier(
    name: String,
    block: suspend CustomDataIdentifierResourceBuilder.() -> Unit,
): CustomDataIdentifier {
    val builder = CustomDataIdentifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDataIdentifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDataIdentifier(name: String): CustomDataIdentifier {
    val builder = CustomDataIdentifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
