@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.aws.macie.CustomDataIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [AWS Macie Custom Data Identifier](https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleCustomDataIdentifier = new aws.macie.CustomDataIdentifier("example", {
 *     name: "NAME OF CUSTOM DATA IDENTIFIER",
 *     regex: "[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *     description: "DESCRIPTION",
 *     maximumMatchDistance: 10,
 *     keywords: ["keyword"],
 *     ignoreWords: ["ignore"],
 * }, {
 *     dependsOn: [test],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_custom_data_identifier = aws.macie.CustomDataIdentifier("example",
 *     name="NAME OF CUSTOM DATA IDENTIFIER",
 *     regex="[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *     description="DESCRIPTION",
 *     maximum_match_distance=10,
 *     keywords=["keyword"],
 *     ignore_words=["ignore"],
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleCustomDataIdentifier = new Aws.Macie.CustomDataIdentifier("example", new()
 *     {
 *         Name = "NAME OF CUSTOM DATA IDENTIFIER",
 *         Regex = "[0-9]{3}-[0-9]{2}-[0-9]{4}",
 *         Description = "DESCRIPTION",
 *         MaximumMatchDistance = 10,
 *         Keywords = new[]
 *         {
 *             "keyword",
 *         },
 *         IgnoreWords = new[]
 *         {
 *             "ignore",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie.NewCustomDataIdentifier(ctx, "example", &macie.CustomDataIdentifierArgs{
 * 			Name:                 pulumi.String("NAME OF CUSTOM DATA IDENTIFIER"),
 * 			Regex:                pulumi.String("[0-9]{3}-[0-9]{2}-[0-9]{4}"),
 * 			Description:          pulumi.String("DESCRIPTION"),
 * 			MaximumMatchDistance: pulumi.Int(10),
 * 			Keywords: pulumi.StringArray{
 * 				pulumi.String("keyword"),
 * 			},
 * 			IgnoreWords: pulumi.StringArray{
 * 				pulumi.String("ignore"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			test,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.CustomDataIdentifier;
 * import com.pulumi.aws.macie.CustomDataIdentifierArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleCustomDataIdentifier = new CustomDataIdentifier("exampleCustomDataIdentifier", CustomDataIdentifierArgs.builder()
 *             .name("NAME OF CUSTOM DATA IDENTIFIER")
 *             .regex("[0-9]{3}-[0-9]{2}-[0-9]{4}")
 *             .description("DESCRIPTION")
 *             .maximumMatchDistance(10)
 *             .keywords("keyword")
 *             .ignoreWords("ignore")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleCustomDataIdentifier:
 *     type: aws:macie:CustomDataIdentifier
 *     name: example
 *     properties:
 *       name: NAME OF CUSTOM DATA IDENTIFIER
 *       regex: '[0-9]{3}-[0-9]{2}-[0-9]{4}'
 *       description: DESCRIPTION
 *       maximumMatchDistance: 10
 *       keywords:
 *         - keyword
 *       ignoreWords:
 *         - ignore
 *     options:
 *       dependson:
 *         - ${test}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_custom_data_identifier` using the id. For example:
 * ```sh
 * $ pulumi import aws:macie/customDataIdentifier:CustomDataIdentifier example abcd1
 * ```
 * @property description A custom description of the custom data identifier. The description can contain as many as 512 characters.
 * @property ignoreWords An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
 * @property keywords An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
 * @property maximumMatchDistance The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
 * @property name A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property regex The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
 * @property tags A map of key-value pairs that specifies the tags to associate with the custom data identifier.
 */
public data class CustomDataIdentifierArgs(
    public val description: Output<String>? = null,
    public val ignoreWords: Output<List<String>>? = null,
    public val keywords: Output<List<String>>? = null,
    public val maximumMatchDistance: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val regex: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.CustomDataIdentifierArgs> {
    override fun toJava(): com.pulumi.aws.macie.CustomDataIdentifierArgs =
        com.pulumi.aws.macie.CustomDataIdentifierArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .ignoreWords(ignoreWords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keywords(keywords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maximumMatchDistance(maximumMatchDistance?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .regex(regex?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomDataIdentifierArgs].
 */
@PulumiTagMarker
public class CustomDataIdentifierArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var ignoreWords: Output<List<String>>? = null

    private var keywords: Output<List<String>>? = null

    private var maximumMatchDistance: Output<Int>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var regex: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A custom description of the custom data identifier. The description can contain as many as 512 characters.
     */
    @JvmName("kqnfefvliuryiygy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("ysmjvxeffbgpojgb")
    public suspend fun ignoreWords(`value`: Output<List<String>>) {
        this.ignoreWords = value
    }

    @JvmName("kykemajjcijofgvr")
    public suspend fun ignoreWords(vararg values: Output<String>) {
        this.ignoreWords = Output.all(values.asList())
    }

    /**
     * @param values An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("qptnhxlgjjciengy")
    public suspend fun ignoreWords(values: List<Output<String>>) {
        this.ignoreWords = Output.all(values)
    }

    /**
     * @param value An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("oppvymfkiyxckrag")
    public suspend fun keywords(`value`: Output<List<String>>) {
        this.keywords = value
    }

    @JvmName("sfpxjumuvbgeghqo")
    public suspend fun keywords(vararg values: Output<String>) {
        this.keywords = Output.all(values.asList())
    }

    /**
     * @param values An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("amvyboujwqtxbdlg")
    public suspend fun keywords(values: List<Output<String>>) {
        this.keywords = Output.all(values)
    }

    /**
     * @param value The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     */
    @JvmName("dqqmixjnekvpjkfh")
    public suspend fun maximumMatchDistance(`value`: Output<Int>) {
        this.maximumMatchDistance = value
    }

    /**
     * @param value A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("rdjtbpfdigihtyml")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("iarofnjimmhvrgiu")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    @JvmName("ddyacmchesnhutmj")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("xsphpcwqbhuaxjeg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A custom description of the custom data identifier. The description can contain as many as 512 characters.
     */
    @JvmName("paqvblvqblpssrbm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("jocxlxdixjjqcyaq")
    public suspend fun ignoreWords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreWords = mapped
    }

    /**
     * @param values An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("scdldjmqfuejouro")
    public suspend fun ignoreWords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreWords = mapped
    }

    /**
     * @param value An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("ectskfehkmkuirxg")
    public suspend fun keywords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param values An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("wjpfmpxljiqqoume")
    public suspend fun keywords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param value The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     */
    @JvmName("wnkuspcmawbkkiwu")
    public suspend fun maximumMatchDistance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMatchDistance = mapped
    }

    /**
     * @param value A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("mskeeggkvvuuypfe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("svbikaufwpslxhhm")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    @JvmName("ykbmwyklmdxmepei")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("rlttkugptmmrmqig")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("plgeummikmkbrdyf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomDataIdentifierArgs = CustomDataIdentifierArgs(
        description = description,
        ignoreWords = ignoreWords,
        keywords = keywords,
        maximumMatchDistance = maximumMatchDistance,
        name = name,
        namePrefix = namePrefix,
        regex = regex,
        tags = tags,
    )
}
