@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.aws.macie.FindingsFilterArgs.builder
import com.pulumi.aws.macie.kotlin.inputs.FindingsFilterFindingCriteriaArgs
import com.pulumi.aws.macie.kotlin.inputs.FindingsFilterFindingCriteriaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Findings Filter](https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const test = new aws.macie.FindingsFilter("test", {
 *     name: "NAME OF THE FINDINGS FILTER",
 *     description: "DESCRIPTION",
 *     position: 1,
 *     action: "ARCHIVE",
 *     findingCriteria: {
 *         criterions: [{
 *             field: "region",
 *             eqs: [current&#46;name],
 *         }],
 *     },
 * }, {
 *     dependsOn: [testAwsMacie2Account],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * test = aws.macie.FindingsFilter("test",
 *     name="NAME OF THE FINDINGS FILTER",
 *     description="DESCRIPTION",
 *     position=1,
 *     action="ARCHIVE",
 *     finding_criteria={
 *         "criterions": [{
 *             "field": "region",
 *             "eqs": [current["name"]],
 *         }],
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test_aws_macie2_account]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var test = new Aws.Macie.FindingsFilter("test", new()
 *     {
 *         Name = "NAME OF THE FINDINGS FILTER",
 *         Description = "DESCRIPTION",
 *         Position = 1,
 *         Action = "ARCHIVE",
 *         FindingCriteria = new Aws.Macie.Inputs.FindingsFilterFindingCriteriaArgs
 *         {
 *             Criterions = new[]
 *             {
 *                 new Aws.Macie.Inputs.FindingsFilterFindingCriteriaCriterionArgs
 *                 {
 *                     Field = "region",
 *                     Eqs = new[]
 *                     {
 *                         current.Name,
 *                     },
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             testAwsMacie2Account,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie.NewFindingsFilter(ctx, "test", &macie.FindingsFilterArgs{
 * 			Name:        pulumi.String("NAME OF THE FINDINGS FILTER"),
 * 			Description: pulumi.String("DESCRIPTION"),
 * 			Position:    pulumi.Int(1),
 * 			Action:      pulumi.String("ARCHIVE"),
 * 			FindingCriteria: &macie.FindingsFilterFindingCriteriaArgs{
 * 				Criterions: macie.FindingsFilterFindingCriteriaCriterionArray{
 * 					&macie.FindingsFilterFindingCriteriaCriterionArgs{
 * 						Field: pulumi.String("region"),
 * 						Eqs: pulumi.StringArray{
 * 							current.Name,
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			testAwsMacie2Account,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.FindingsFilter;
 * import com.pulumi.aws.macie.FindingsFilterArgs;
 * import com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var test = new FindingsFilter("test", FindingsFilterArgs.builder()
 *             .name("NAME OF THE FINDINGS FILTER")
 *             .description("DESCRIPTION")
 *             .position(1)
 *             .action("ARCHIVE")
 *             .findingCriteria(FindingsFilterFindingCriteriaArgs.builder()
 *                 .criterions(FindingsFilterFindingCriteriaCriterionArgs.builder()
 *                     .field("region")
 *                     .eqs(current.name())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAwsMacie2Account)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   test:
 *     type: aws:macie:FindingsFilter
 *     properties:
 *       name: NAME OF THE FINDINGS FILTER
 *       description: DESCRIPTION
 *       position: 1
 *       action: ARCHIVE
 *       findingCriteria:
 *         criterions:
 *           - field: region
 *             eqs:
 *               - ${current.name}
 *     options:
 *       dependson:
 *         - ${testAwsMacie2Account}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_findings_filter` using the id. For example:
 * ```sh
 * $ pulumi import aws:macie/findingsFilter:FindingsFilter example abcd1
 * ```
 * @property action The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
 * @property description A custom description of the filter. The description can contain as many as 512 characters.
 * @property findingCriteria The criteria to use to filter findings.
 * @property name A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property position The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
 * @property tags A map of key-value pairs that specifies the tags to associate with the filter.
 */
public data class FindingsFilterArgs(
    public val action: Output<String>? = null,
    public val description: Output<String>? = null,
    public val findingCriteria: Output<FindingsFilterFindingCriteriaArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val position: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.FindingsFilterArgs> {
    override fun toJava(): com.pulumi.aws.macie.FindingsFilterArgs =
        com.pulumi.aws.macie.FindingsFilterArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .findingCriteria(findingCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FindingsFilterArgs].
 */
@PulumiTagMarker
public class FindingsFilterArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var description: Output<String>? = null

    private var findingCriteria: Output<FindingsFilterFindingCriteriaArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var position: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
     */
    @JvmName("lahqcwfksvthhopr")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value A custom description of the filter. The description can contain as many as 512 characters.
     */
    @JvmName("xjaepjhiwkjxnyca")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The criteria to use to filter findings.
     */
    @JvmName("kgnfsgsrqdvrntnn")
    public suspend fun findingCriteria(`value`: Output<FindingsFilterFindingCriteriaArgs>) {
        this.findingCriteria = value
    }

    /**
     * @param value A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("orgtvsbskhcwiltv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("hlvpasxpwgherwaj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    @JvmName("qpwwspoxjfqgdnep")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("pnkgrhricetkbgxa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
     */
    @JvmName("xwuvcowcxjudlund")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value A custom description of the filter. The description can contain as many as 512 characters.
     */
    @JvmName("wigughndxqdtllcp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The criteria to use to filter findings.
     */
    @JvmName("kvkcaclrywjkwrcm")
    public suspend fun findingCriteria(`value`: FindingsFilterFindingCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingCriteria = mapped
    }

    /**
     * @param argument The criteria to use to filter findings.
     */
    @JvmName("rgsomkargnbsqvry")
    public suspend fun findingCriteria(argument: suspend FindingsFilterFindingCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = FindingsFilterFindingCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.findingCriteria = mapped
    }

    /**
     * @param value A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("cojhtfvvjaadxfey")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("eahoswbcratxvgsv")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    @JvmName("mwfutwbluufhfbes")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("wunnvrlovukxumin")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("odcvkicdbddbujla")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FindingsFilterArgs = FindingsFilterArgs(
        action = action,
        description = description,
        findingCriteria = findingCriteria,
        name = name,
        namePrefix = namePrefix,
        position = position,
        tags = tags,
    )
}
