@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin.inputs

import com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property criterions A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
 */
public data class FindingsFilterFindingCriteriaArgs(
    public val criterions: Output<List<FindingsFilterFindingCriteriaCriterionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs =
        com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs.builder()
            .criterions(
                criterions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FindingsFilterFindingCriteriaArgs].
 */
@PulumiTagMarker
public class FindingsFilterFindingCriteriaArgsBuilder internal constructor() {
    private var criterions: Output<List<FindingsFilterFindingCriteriaCriterionArgs>>? = null

    /**
     * @param value A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("aadyjauptcqkwypo")
    public suspend fun criterions(`value`: Output<List<FindingsFilterFindingCriteriaCriterionArgs>>) {
        this.criterions = value
    }

    @JvmName("jytxgguprkclheit")
    public suspend fun criterions(vararg values: Output<FindingsFilterFindingCriteriaCriterionArgs>) {
        this.criterions = Output.all(values.asList())
    }

    /**
     * @param values A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("hkfxvwrnqskjwkvp")
    public suspend fun criterions(values: List<Output<FindingsFilterFindingCriteriaCriterionArgs>>) {
        this.criterions = Output.all(values)
    }

    /**
     * @param value A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("pnrcnpuucwvhimtf")
    public suspend fun criterions(`value`: List<FindingsFilterFindingCriteriaCriterionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criterions = mapped
    }

    /**
     * @param argument A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("cjvirfmbaiapxyoq")
    public suspend fun criterions(argument: List<suspend FindingsFilterFindingCriteriaCriterionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FindingsFilterFindingCriteriaCriterionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.criterions = mapped
    }

    /**
     * @param argument A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("axisiofrbmaxjuog")
    public suspend fun criterions(vararg argument: suspend FindingsFilterFindingCriteriaCriterionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FindingsFilterFindingCriteriaCriterionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.criterions = mapped
    }

    /**
     * @param argument A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("drunpwksjvyvlcih")
    public suspend fun criterions(argument: suspend FindingsFilterFindingCriteriaCriterionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FindingsFilterFindingCriteriaCriterionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.criterions = mapped
    }

    /**
     * @param values A condition that specifies the property, operator, and one or more values to use to filter the results.  (documented below)
     */
    @JvmName("pxmqfncnlpwhvjsi")
    public suspend fun criterions(vararg values: FindingsFilterFindingCriteriaCriterionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criterions = mapped
    }

    internal fun build(): FindingsFilterFindingCriteriaArgs = FindingsFilterFindingCriteriaArgs(
        criterions = criterions,
    )
}
