@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.kotlin.outputs.ClassificationExportConfigurationS3Destination
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationExportConfigurationS3Destination.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClassificationExportConfiguration].
 */
@PulumiTagMarker
public class ClassificationExportConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClassificationExportConfigurationArgs = ClassificationExportConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClassificationExportConfigurationArgsBuilder.() -> Unit) {
        val builder = ClassificationExportConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClassificationExportConfiguration {
        val builtJavaResource =
            com.pulumi.aws.macie2.ClassificationExportConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClassificationExportConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleClassificationExportConfiguration = new aws.macie2.ClassificationExportConfiguration("example", {s3Destination: {
 *     bucketName: exampleAwsS3Bucket.bucket,
 *     keyPrefix: "exampleprefix/",
 *     kmsKeyArn: exampleAwsKmsKey.arn,
 * }}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_classification_export_configuration = aws.macie2.ClassificationExportConfiguration("example", s3_destination={
 *     "bucket_name": example_aws_s3_bucket["bucket"],
 *     "key_prefix": "exampleprefix/",
 *     "kms_key_arn": example_aws_kms_key["arn"],
 * },
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleClassificationExportConfiguration = new Aws.Macie2.ClassificationExportConfiguration("example", new()
 *     {
 *         S3Destination = new Aws.Macie2.Inputs.ClassificationExportConfigurationS3DestinationArgs
 *         {
 *             BucketName = exampleAwsS3Bucket.Bucket,
 *             KeyPrefix = "exampleprefix/",
 *             KmsKeyArn = exampleAwsKmsKey.Arn,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewClassificationExportConfiguration(ctx, "example", &macie2.ClassificationExportConfigurationArgs{
 * 			S3Destination: &macie2.ClassificationExportConfigurationS3DestinationArgs{
 * 				BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 				KeyPrefix:  pulumi.String("exampleprefix/"),
 * 				KmsKeyArn:  pulumi.Any(exampleAwsKmsKey.Arn),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationExportConfiguration;
 * import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleClassificationExportConfiguration = new ClassificationExportConfiguration("exampleClassificationExportConfiguration", ClassificationExportConfigurationArgs.builder()
 *             .s3Destination(ClassificationExportConfigurationS3DestinationArgs.builder()
 *                 .bucketName(exampleAwsS3Bucket.bucket())
 *                 .keyPrefix("exampleprefix/")
 *                 .kmsKeyArn(exampleAwsKmsKey.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleClassificationExportConfiguration:
 *     type: aws:macie2:ClassificationExportConfiguration
 *     name: example
 *     properties:
 *       s3Destination:
 *         bucketName: ${exampleAwsS3Bucket.bucket}
 *         keyPrefix: exampleprefix/
 *         kmsKeyArn: ${exampleAwsKmsKey.arn}
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the account ID and region. For example:
 * ```sh
 * $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example 123456789012:us-west-2
 * ```
 */
public class ClassificationExportConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.macie2.ClassificationExportConfiguration,
) : KotlinCustomResource(javaResource, ClassificationExportConfigurationMapper) {
    /**
     * Configuration block for a S3 Destination. Defined below
     */
    public val s3Destination: Output<ClassificationExportConfigurationS3Destination>?
        get() = javaResource.s3Destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object ClassificationExportConfigurationMapper :
    ResourceMapper<ClassificationExportConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.ClassificationExportConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ClassificationExportConfiguration =
        ClassificationExportConfiguration(
            javaResource as
                com.pulumi.aws.macie2.ClassificationExportConfiguration,
        )
}

/**
 * @see [ClassificationExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClassificationExportConfiguration].
 */
public suspend fun classificationExportConfiguration(
    name: String,
    block: suspend ClassificationExportConfigurationResourceBuilder.() -> Unit,
): ClassificationExportConfiguration {
    val builder = ClassificationExportConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClassificationExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun classificationExportConfiguration(name: String): ClassificationExportConfiguration {
    val builder = ClassificationExportConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
