@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs.builder
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationExportConfigurationS3DestinationArgs
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationExportConfigurationS3DestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleClassificationExportConfiguration = new aws.macie2.ClassificationExportConfiguration("example", {s3Destination: {
 *     bucketName: exampleAwsS3Bucket.bucket,
 *     keyPrefix: "exampleprefix/",
 *     kmsKeyArn: exampleAwsKmsKey.arn,
 * }}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_classification_export_configuration = aws.macie2.ClassificationExportConfiguration("example", s3_destination={
 *     "bucket_name": example_aws_s3_bucket["bucket"],
 *     "key_prefix": "exampleprefix/",
 *     "kms_key_arn": example_aws_kms_key["arn"],
 * },
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleClassificationExportConfiguration = new Aws.Macie2.ClassificationExportConfiguration("example", new()
 *     {
 *         S3Destination = new Aws.Macie2.Inputs.ClassificationExportConfigurationS3DestinationArgs
 *         {
 *             BucketName = exampleAwsS3Bucket.Bucket,
 *             KeyPrefix = "exampleprefix/",
 *             KmsKeyArn = exampleAwsKmsKey.Arn,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewClassificationExportConfiguration(ctx, "example", &macie2.ClassificationExportConfigurationArgs{
 * 			S3Destination: &macie2.ClassificationExportConfigurationS3DestinationArgs{
 * 				BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 				KeyPrefix:  pulumi.String("exampleprefix/"),
 * 				KmsKeyArn:  pulumi.Any(exampleAwsKmsKey.Arn),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationExportConfiguration;
 * import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleClassificationExportConfiguration = new ClassificationExportConfiguration("exampleClassificationExportConfiguration", ClassificationExportConfigurationArgs.builder()
 *             .s3Destination(ClassificationExportConfigurationS3DestinationArgs.builder()
 *                 .bucketName(exampleAwsS3Bucket.bucket())
 *                 .keyPrefix("exampleprefix/")
 *                 .kmsKeyArn(exampleAwsKmsKey.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleClassificationExportConfiguration:
 *     type: aws:macie2:ClassificationExportConfiguration
 *     name: example
 *     properties:
 *       s3Destination:
 *         bucketName: ${exampleAwsS3Bucket.bucket}
 *         keyPrefix: exampleprefix/
 *         kmsKeyArn: ${exampleAwsKmsKey.arn}
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the account ID and region. For example:
 * ```sh
 * $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example 123456789012:us-west-2
 * ```
 * @property s3Destination Configuration block for a S3 Destination. Defined below
 */
public data class ClassificationExportConfigurationArgs(
    public val s3Destination: Output<ClassificationExportConfigurationS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.ClassificationExportConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.macie2.ClassificationExportConfigurationArgs =
        com.pulumi.aws.macie2.ClassificationExportConfigurationArgs.builder()
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationExportConfigurationArgs].
 */
@PulumiTagMarker
public class ClassificationExportConfigurationArgsBuilder internal constructor() {
    private var s3Destination: Output<ClassificationExportConfigurationS3DestinationArgs>? = null

    /**
     * @param value Configuration block for a S3 Destination. Defined below
     */
    @JvmName("buypctdrqowwhhvn")
    public suspend fun s3Destination(`value`: Output<ClassificationExportConfigurationS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value Configuration block for a S3 Destination. Defined below
     */
    @JvmName("bmhdopwmxaiohdvf")
    public suspend fun s3Destination(`value`: ClassificationExportConfigurationS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument Configuration block for a S3 Destination. Defined below
     */
    @JvmName("fghmmqcsefpeixen")
    public suspend fun s3Destination(argument: suspend ClassificationExportConfigurationS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationExportConfigurationS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): ClassificationExportConfigurationArgs =
        ClassificationExportConfigurationArgs(
            s3Destination = s3Destination,
        )
}
