@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinition
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobScheduleFrequency
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobUserPausedDetail
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinition.Companion.toKotlin as classificationJobS3JobDefinitionToKotlin
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobScheduleFrequency.Companion.toKotlin as classificationJobScheduleFrequencyToKotlin
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobUserPausedDetail.Companion.toKotlin as classificationJobUserPausedDetailToKotlin

/**
 * Builder for [ClassificationJob].
 */
@PulumiTagMarker
public class ClassificationJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClassificationJobArgs = ClassificationJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClassificationJobArgsBuilder.() -> Unit) {
        val builder = ClassificationJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClassificationJob {
        val builtJavaResource = com.pulumi.aws.macie2.ClassificationJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClassificationJob(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [AWS Macie Classification Job](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.macie2.Account("test", {});
 * const testClassificationJob = new aws.macie2.ClassificationJob("test", {
 *     jobType: "ONE_TIME",
 *     name: "NAME OF THE CLASSIFICATION JOB",
 *     s3JobDefinition: {
 *         bucketDefinitions: [{
 *             accountId: "ACCOUNT ID",
 *             buckets: ["S3 BUCKET NAME"],
 *         }],
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.macie2.Account("test")
 * test_classification_job = aws.macie2.ClassificationJob("test",
 *     job_type="ONE_TIME",
 *     name="NAME OF THE CLASSIFICATION JOB",
 *     s3_job_definition={
 *         "bucket_definitions": [{
 *             "account_id": "ACCOUNT ID",
 *             "buckets": ["S3 BUCKET NAME"],
 *         }],
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Macie2.Account("test");
 *     var testClassificationJob = new Aws.Macie2.ClassificationJob("test", new()
 *     {
 *         JobType = "ONE_TIME",
 *         Name = "NAME OF THE CLASSIFICATION JOB",
 *         S3JobDefinition = new Aws.Macie2.Inputs.ClassificationJobS3JobDefinitionArgs
 *         {
 *             BucketDefinitions = new[]
 *             {
 *                 new Aws.Macie2.Inputs.ClassificationJobS3JobDefinitionBucketDefinitionArgs
 *                 {
 *                     AccountId = "ACCOUNT ID",
 *                     Buckets = new[]
 *                     {
 *                         "S3 BUCKET NAME",
 *                     },
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := macie2.NewAccount(ctx, "test", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewClassificationJob(ctx, "test", &macie2.ClassificationJobArgs{
 * 			JobType: pulumi.String("ONE_TIME"),
 * 			Name:    pulumi.String("NAME OF THE CLASSIFICATION JOB"),
 * 			S3JobDefinition: &macie2.ClassificationJobS3JobDefinitionArgs{
 * 				BucketDefinitions: macie2.ClassificationJobS3JobDefinitionBucketDefinitionArray{
 * 					&macie2.ClassificationJobS3JobDefinitionBucketDefinitionArgs{
 * 						AccountId: pulumi.String("ACCOUNT ID"),
 * 						Buckets: pulumi.StringArray{
 * 							pulumi.String("S3 BUCKET NAME"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			test,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationJob;
 * import com.pulumi.aws.macie2.ClassificationJobArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Account("test");
 *         var testClassificationJob = new ClassificationJob("testClassificationJob", ClassificationJobArgs.builder()
 *             .jobType("ONE_TIME")
 *             .name("NAME OF THE CLASSIFICATION JOB")
 *             .s3JobDefinition(ClassificationJobS3JobDefinitionArgs.builder()
 *                 .bucketDefinitions(ClassificationJobS3JobDefinitionBucketDefinitionArgs.builder()
 *                     .accountId("ACCOUNT ID")
 *                     .buckets("S3 BUCKET NAME")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:macie2:Account
 *   testClassificationJob:
 *     type: aws:macie2:ClassificationJob
 *     name: test
 *     properties:
 *       jobType: ONE_TIME
 *       name: NAME OF THE CLASSIFICATION JOB
 *       s3JobDefinition:
 *         bucketDefinitions:
 *           - accountId: ACCOUNT ID
 *             buckets:
 *               - S3 BUCKET NAME
 *     options:
 *       dependson:
 *         - ${test}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_job` using the id. For example:
 * ```sh
 * $ pulumi import aws:macie2/classificationJob:ClassificationJob example abcd1
 * ```
 */
public class ClassificationJob internal constructor(
    override val javaResource: com.pulumi.aws.macie2.ClassificationJob,
) : KotlinCustomResource(javaResource, ClassificationJobMapper) {
    /**
     * The date and time, in UTC and extended RFC 3339 format, when the job was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The custom data identifiers to use for data analysis and classification.
     */
    public val customDataIdentifierIds: Output<List<String>>
        get() = javaResource.customDataIdentifierIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A custom description of the job. The description can contain as many as 200 characters.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     */
    public val initialRun: Output<Boolean>?
        get() = javaResource.initialRun().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val jobArn: Output<String>
        get() = javaResource.jobArn().applyValue({ args0 -> args0 })

    public val jobId: Output<String>
        get() = javaResource.jobId().applyValue({ args0 -> args0 })

    /**
     * The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
     */
    public val jobStatus: Output<String>
        get() = javaResource.jobStatus().applyValue({ args0 -> args0 })

    /**
     * The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
     */
    public val jobType: Output<String>
        get() = javaResource.jobType().applyValue({ args0 -> args0 })

    /**
     * A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     */
    public val s3JobDefinition: Output<ClassificationJobS3JobDefinition>
        get() = javaResource.s3JobDefinition().applyValue({ args0 ->
            args0.let({ args0 ->
                classificationJobS3JobDefinitionToKotlin(args0)
            })
        })

    /**
     * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     */
    public val samplingPercentage: Output<Int>
        get() = javaResource.samplingPercentage().applyValue({ args0 -> args0 })

    /**
     * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     */
    public val scheduleFrequency: Output<ClassificationJobScheduleFrequency>
        get() = javaResource.scheduleFrequency().applyValue({ args0 ->
            args0.let({ args0 ->
                classificationJobScheduleFrequencyToKotlin(args0)
            })
        })

    /**
     * A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be canceled if it isn't resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
     */
    public val userPausedDetails: Output<List<ClassificationJobUserPausedDetail>>
        get() = javaResource.userPausedDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classificationJobUserPausedDetailToKotlin(args0) })
            })
        })
}

public object ClassificationJobMapper : ResourceMapper<ClassificationJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.ClassificationJob::class == javaResource::class

    override fun map(javaResource: Resource): ClassificationJob = ClassificationJob(
        javaResource as
            com.pulumi.aws.macie2.ClassificationJob,
    )
}

/**
 * @see [ClassificationJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClassificationJob].
 */
public suspend fun classificationJob(
    name: String,
    block: suspend ClassificationJobResourceBuilder.() -> Unit,
): ClassificationJob {
    val builder = ClassificationJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClassificationJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun classificationJob(name: String): ClassificationJob {
    val builder = ClassificationJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
