@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InvitationAccepter].
 */
@PulumiTagMarker
public class InvitationAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvitationAccepterArgs = InvitationAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvitationAccepterArgsBuilder.() -> Unit) {
        val builder = InvitationAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InvitationAccepter {
        val builtJavaResource = com.pulumi.aws.macie2.InvitationAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InvitationAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Invitation Accepter](https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.macie2.Account("primary", {});
 * const member = new aws.macie2.Account("member", {});
 * const primaryMember = new aws.macie2.Member("primary", {
 *     accountId: "ACCOUNT ID",
 *     email: "EMAIL",
 *     invite: true,
 *     invitationMessage: "Message of the invite",
 * }, {
 *     dependsOn: [primary],
 * });
 * const memberInvitationAccepter = new aws.macie2.InvitationAccepter("member", {administratorAccountId: "ADMINISTRATOR ACCOUNT ID"}, {
 *     dependsOn: [primaryMember],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.macie2.Account("primary")
 * member = aws.macie2.Account("member")
 * primary_member = aws.macie2.Member("primary",
 *     account_id="ACCOUNT ID",
 *     email="EMAIL",
 *     invite=True,
 *     invitation_message="Message of the invite",
 *     opts = pulumi.ResourceOptions(depends_on=[primary]))
 * member_invitation_accepter = aws.macie2.InvitationAccepter("member", administrator_account_id="ADMINISTRATOR ACCOUNT ID",
 * opts = pulumi.ResourceOptions(depends_on=[primary_member]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.Macie2.Account("primary");
 *     var member = new Aws.Macie2.Account("member");
 *     var primaryMember = new Aws.Macie2.Member("primary", new()
 *     {
 *         AccountId = "ACCOUNT ID",
 *         Email = "EMAIL",
 *         Invite = true,
 *         InvitationMessage = "Message of the invite",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primary,
 *         },
 *     });
 *     var memberInvitationAccepter = new Aws.Macie2.InvitationAccepter("member", new()
 *     {
 *         AdministratorAccountId = "ADMINISTRATOR ACCOUNT ID",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primaryMember,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := macie2.NewAccount(ctx, "primary", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewAccount(ctx, "member", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primaryMember, err := macie2.NewMember(ctx, "primary", &macie2.MemberArgs{
 * 			AccountId:         pulumi.String("ACCOUNT ID"),
 * 			Email:             pulumi.String("EMAIL"),
 * 			Invite:            pulumi.Bool(true),
 * 			InvitationMessage: pulumi.String("Message of the invite"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primary,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewInvitationAccepter(ctx, "member", &macie2.InvitationAccepterArgs{
 * 			AdministratorAccountId: pulumi.String("ADMINISTRATOR ACCOUNT ID"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primaryMember,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.Member;
 * import com.pulumi.aws.macie2.MemberArgs;
 * import com.pulumi.aws.macie2.InvitationAccepter;
 * import com.pulumi.aws.macie2.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Account("primary");
 *         var member = new Account("member");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .email("EMAIL")
 *             .invite(true)
 *             .invitationMessage("Message of the invite")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primary)
 *                 .build());
 *         var memberInvitationAccepter = new InvitationAccepter("memberInvitationAccepter", InvitationAccepterArgs.builder()
 *             .administratorAccountId("ADMINISTRATOR ACCOUNT ID")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:macie2:Account
 *   member:
 *     type: aws:macie2:Account
 *   primaryMember:
 *     type: aws:macie2:Member
 *     name: primary
 *     properties:
 *       accountId: ACCOUNT ID
 *       email: EMAIL
 *       invite: true
 *       invitationMessage: Message of the invite
 *     options:
 *       dependson:
 *         - ${primary}
 *   memberInvitationAccepter:
 *     type: aws:macie2:InvitationAccepter
 *     name: member
 *     properties:
 *       administratorAccountId: ADMINISTRATOR ACCOUNT ID
 *     options:
 *       dependson:
 *         - ${primaryMember}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_invitation_accepter` using the admin account ID. For example:
 * ```sh
 * $ pulumi import aws:macie2/invitationAccepter:InvitationAccepter example 123456789012
 * ```
 */
public class InvitationAccepter internal constructor(
    override val javaResource: com.pulumi.aws.macie2.InvitationAccepter,
) : KotlinCustomResource(javaResource, InvitationAccepterMapper) {
    /**
     * The AWS account ID for the account that sent the invitation.
     */
    public val administratorAccountId: Output<String>
        get() = javaResource.administratorAccountId().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the invitation.
     */
    public val invitationId: Output<String>
        get() = javaResource.invitationId().applyValue({ args0 -> args0 })
}

public object InvitationAccepterMapper : ResourceMapper<InvitationAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.InvitationAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InvitationAccepter = InvitationAccepter(
        javaResource as
            com.pulumi.aws.macie2.InvitationAccepter,
    )
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InvitationAccepter].
 */
public suspend fun invitationAccepter(
    name: String,
    block: suspend InvitationAccepterResourceBuilder.() -> Unit,
): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invitationAccepter(name: String): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
