@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Member].
 */
@PulumiTagMarker
public class MemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MemberArgs = MemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MemberArgsBuilder.() -> Unit) {
        val builder = MemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Member {
        val builtJavaResource = com.pulumi.aws.macie2.Member(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Member(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Member](https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleMember = new aws.macie2.Member("example", {
 *     accountId: "AWS ACCOUNT ID",
 *     email: "EMAIL",
 *     invite: true,
 *     invitationMessage: "Message of the invitation",
 *     invitationDisableEmailNotification: true,
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_member = aws.macie2.Member("example",
 *     account_id="AWS ACCOUNT ID",
 *     email="EMAIL",
 *     invite=True,
 *     invitation_message="Message of the invitation",
 *     invitation_disable_email_notification=True,
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleMember = new Aws.Macie2.Member("example", new()
 *     {
 *         AccountId = "AWS ACCOUNT ID",
 *         Email = "EMAIL",
 *         Invite = true,
 *         InvitationMessage = "Message of the invitation",
 *         InvitationDisableEmailNotification = true,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewMember(ctx, "example", &macie2.MemberArgs{
 * 			AccountId:                          pulumi.String("AWS ACCOUNT ID"),
 * 			Email:                              pulumi.String("EMAIL"),
 * 			Invite:                             pulumi.Bool(true),
 * 			InvitationMessage:                  pulumi.String("Message of the invitation"),
 * 			InvitationDisableEmailNotification: pulumi.Bool(true),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.Member;
 * import com.pulumi.aws.macie2.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("AWS ACCOUNT ID")
 *             .email("EMAIL")
 *             .invite(true)
 *             .invitationMessage("Message of the invitation")
 *             .invitationDisableEmailNotification(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleMember:
 *     type: aws:macie2:Member
 *     name: example
 *     properties:
 *       accountId: AWS ACCOUNT ID
 *       email: EMAIL
 *       invite: true
 *       invitationMessage: Message of the invitation
 *       invitationDisableEmailNotification: true
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_member` using the account ID of the member account. For example:
 * ```sh
 * $ pulumi import aws:macie2/member:Member example 123456789012
 * ```
 */
public class Member internal constructor(
    override val javaResource: com.pulumi.aws.macie2.Member,
) : KotlinCustomResource(javaResource, MemberMapper) {
    /**
     * The AWS account ID for the account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID for the administrator account.
     */
    public val administratorAccountId: Output<String>
        get() = javaResource.administratorAccountId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the account.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The email address for the account.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. To send an email notification to the root user of each account, set this value to `true`.
     */
    public val invitationDisableEmailNotification: Output<Boolean>?
        get() = javaResource.invitationDisableEmailNotification().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.
     */
    public val invitationMessage: Output<String>?
        get() = javaResource.invitationMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Send an invitation to a member
     */
    public val invite: Output<Boolean>
        get() = javaResource.invite().applyValue({ args0 -> args0 })

    /**
     * The date and time, in UTC and extended RFC 3339 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie invitation hasn't been sent to the account.
     */
    public val invitedAt: Output<String>
        get() = javaResource.invitedAt().applyValue({ args0 -> args0 })

    public val masterAccountId: Output<String>
        get() = javaResource.masterAccountId().applyValue({ args0 -> args0 })

    /**
     * The current status of the relationship between the account and the administrator account.
     */
    public val relationshipStatus: Output<String>
        get() = javaResource.relationshipStatus().applyValue({ args0 -> args0 })

    /**
     * Specifies the status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to `ENABLED`. Valid values are `ENABLED` or `PAUSED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The date and time, in UTC and extended RFC 3339 format, of the most recent change to the status of the relationship between the account and the administrator account.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object MemberMapper : ResourceMapper<Member> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.Member::class == javaResource::class

    override fun map(javaResource: Resource): Member = Member(
        javaResource as
            com.pulumi.aws.macie2.Member,
    )
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Member].
 */
public suspend fun member(name: String, block: suspend MemberResourceBuilder.() -> Unit): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 */
public fun member(name: String): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
