@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationAdminAccount].
 */
@PulumiTagMarker
public class OrganizationAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationAdminAccountArgs = OrganizationAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationAdminAccountArgsBuilder.() -> Unit) {
        val builder = OrganizationAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationAdminAccount {
        val builtJavaResource = com.pulumi.aws.macie2.OrganizationAdminAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationAdminAccount(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Organization Admin Account](https://docs.aws.amazon.com/macie/latest/APIReference/admin.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.macie2.Account("example", {});
 * const exampleOrganizationAdminAccount = new aws.macie2.OrganizationAdminAccount("example", {adminAccountId: "ID OF THE ADMIN ACCOUNT"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.macie2.Account("example")
 * example_organization_admin_account = aws.macie2.OrganizationAdminAccount("example", admin_account_id="ID OF THE ADMIN ACCOUNT",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Macie2.Account("example");
 *     var exampleOrganizationAdminAccount = new Aws.Macie2.OrganizationAdminAccount("example", new()
 *     {
 *         AdminAccountId = "ID OF THE ADMIN ACCOUNT",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/macie2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := macie2.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = macie2.NewOrganizationAdminAccount(ctx, "example", &macie2.OrganizationAdminAccountArgs{
 * 			AdminAccountId: pulumi.String("ID OF THE ADMIN ACCOUNT"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.OrganizationAdminAccount;
 * import com.pulumi.aws.macie2.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("ID OF THE ADMIN ACCOUNT")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:macie2:Account
 *   exampleOrganizationAdminAccount:
 *     type: aws:macie2:OrganizationAdminAccount
 *     name: example
 *     properties:
 *       adminAccountId: ID OF THE ADMIN ACCOUNT
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_macie2_organization_admin_account` using the id. For example:
 * ```sh
 * $ pulumi import aws:macie2/organizationAdminAccount:OrganizationAdminAccount example abcd1
 * ```
 */
public class OrganizationAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.macie2.OrganizationAdminAccount,
) : KotlinCustomResource(javaResource, OrganizationAdminAccountMapper) {
    /**
     * The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     */
    public val adminAccountId: Output<String>
        get() = javaResource.adminAccountId().applyValue({ args0 -> args0 })
}

public object OrganizationAdminAccountMapper : ResourceMapper<OrganizationAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.OrganizationAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationAdminAccount =
        OrganizationAdminAccount(javaResource as com.pulumi.aws.macie2.OrganizationAdminAccount)
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationAdminAccount].
 */
public suspend fun organizationAdminAccount(
    name: String,
    block: suspend OrganizationAdminAccountResourceBuilder.() -> Unit,
): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationAdminAccount(name: String): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
