@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
 * @property keyPrefix The object key for the bucket in which Amazon Macie exports the data classification results.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 * Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
 */
public data class ClassificationExportConfigurationS3DestinationArgs(
    public val bucketName: Output<String>,
    public val keyPrefix: Output<String>? = null,
    public val kmsKeyArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs =
        com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .keyPrefix(keyPrefix?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationExportConfigurationS3DestinationArgs].
 */
@PulumiTagMarker
public class ClassificationExportConfigurationS3DestinationArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var keyPrefix: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
     */
    @JvmName("uqecpbxgolffoctd")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The object key for the bucket in which Amazon Macie exports the data classification results.
     */
    @JvmName("npsogvndswqowvca")
    public suspend fun keyPrefix(`value`: Output<String>) {
        this.keyPrefix = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     * Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
     */
    @JvmName("vsejuheanjrgcxrl")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
     */
    @JvmName("aouluaxehcyjjdol")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The object key for the bucket in which Amazon Macie exports the data classification results.
     */
    @JvmName("ylgwywuhwuuxlpqi")
    public suspend fun keyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefix = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     * Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
     */
    @JvmName("oswodgnrbdgoleml")
    public suspend fun kmsKeyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): ClassificationExportConfigurationS3DestinationArgs =
        ClassificationExportConfigurationS3DestinationArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            keyPrefix = keyPrefix,
            kmsKeyArn = kmsKeyArn ?: throw PulumiNullFieldException("kmsKeyArn"),
        )
}
