@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bucketCriteria The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
 * @property bucketDefinitions An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
 * @property scoping The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
 */
public data class ClassificationJobS3JobDefinitionArgs(
    public val bucketCriteria: Output<ClassificationJobS3JobDefinitionBucketCriteriaArgs>? = null,
    public val bucketDefinitions: Output<List<ClassificationJobS3JobDefinitionBucketDefinitionArgs>>? =
        null,
    public val scoping: Output<ClassificationJobS3JobDefinitionScopingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs.builder()
            .bucketCriteria(bucketCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bucketDefinitions(
                bucketDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scoping(scoping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionArgsBuilder internal constructor() {
    private var bucketCriteria: Output<ClassificationJobS3JobDefinitionBucketCriteriaArgs>? = null

    private var bucketDefinitions: Output<List<ClassificationJobS3JobDefinitionBucketDefinitionArgs>>? =
        null

    private var scoping: Output<ClassificationJobS3JobDefinitionScopingArgs>? = null

    /**
     * @param value The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
     */
    @JvmName("xdnwrkadatdpeaov")
    public suspend fun bucketCriteria(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaArgs>) {
        this.bucketCriteria = value
    }

    /**
     * @param value An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("wntnnqqbvhuteknp")
    public suspend fun bucketDefinitions(`value`: Output<List<ClassificationJobS3JobDefinitionBucketDefinitionArgs>>) {
        this.bucketDefinitions = value
    }

    @JvmName("hxppcputdhlyundj")
    public suspend fun bucketDefinitions(vararg values: Output<ClassificationJobS3JobDefinitionBucketDefinitionArgs>) {
        this.bucketDefinitions = Output.all(values.asList())
    }

    /**
     * @param values An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("ahxgageighodssae")
    public suspend fun bucketDefinitions(values: List<Output<ClassificationJobS3JobDefinitionBucketDefinitionArgs>>) {
        this.bucketDefinitions = Output.all(values)
    }

    /**
     * @param value The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
     */
    @JvmName("xubfblccywbiulnl")
    public suspend fun scoping(`value`: Output<ClassificationJobS3JobDefinitionScopingArgs>) {
        this.scoping = value
    }

    /**
     * @param value The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
     */
    @JvmName("cphlijylqqrhgwtu")
    public suspend fun bucketCriteria(`value`: ClassificationJobS3JobDefinitionBucketCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketCriteria = mapped
    }

    /**
     * @param argument The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
     */
    @JvmName("arumismrbwyoydrr")
    public suspend fun bucketCriteria(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobS3JobDefinitionBucketCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.bucketCriteria = mapped
    }

    /**
     * @param value An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("efooiwrwhhimhwgq")
    public suspend fun bucketDefinitions(`value`: List<ClassificationJobS3JobDefinitionBucketDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketDefinitions = mapped
    }

    /**
     * @param argument An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("hrnyealhpbepyhyt")
    public suspend fun bucketDefinitions(argument: List<suspend ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bucketDefinitions = mapped
    }

    /**
     * @param argument An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("cuypcxiubsnpgovi")
    public suspend fun bucketDefinitions(vararg argument: suspend ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bucketDefinitions = mapped
    }

    /**
     * @param argument An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("xphahvpqpxhmlmbj")
    public suspend fun bucketDefinitions(argument: suspend ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.bucketDefinitions = mapped
    }

    /**
     * @param values An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
     */
    @JvmName("pbwrgmmradiredfr")
    public suspend fun bucketDefinitions(vararg values: ClassificationJobS3JobDefinitionBucketDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketDefinitions = mapped
    }

    /**
     * @param value The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
     */
    @JvmName("odlcsupqwimyjcig")
    public suspend fun scoping(`value`: ClassificationJobS3JobDefinitionScopingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scoping = mapped
    }

    /**
     * @param argument The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
     */
    @JvmName("pkngavnedagulueu")
    public suspend fun scoping(argument: suspend ClassificationJobS3JobDefinitionScopingArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobS3JobDefinitionScopingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scoping = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionArgs = ClassificationJobS3JobDefinitionArgs(
        bucketCriteria = bucketCriteria,
        bucketDefinitions = bucketDefinitions,
        scoping = scoping,
    )
}
